/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.railcraft;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Collection;
import mods.neiplugins.NEIPlugins;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.opengl.GL11;

public class RollingMachineRecipeHandler
extends ShapedRecipeHandler {
    public static final int yOffset = 2;
    public static Class<? extends GuiContainer> guiclass;

    public String getRecipeName() {
        return "Rolling Machine";
    }

    public String getRecipeNameSub() {
        return "Shaped";
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)this.getOverlayIdentifier()) || RecipeInfo.hasOverlayHandler((GuiContainer)gui, (String)this.getOverlayIdentifier());
    }

    public String getGuiTexture() {
        return "railcraft:textures/gui/gui_rolling.png";
    }

    public String getOverlayIdentifier() {
        return "railcraft.rolling";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 39, 24, 10), "railcraft.rolling", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiclass;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)2, (int)5, (int)11, (int)150, (int)65);
    }

    public void drawExtras(int recipe) {
        if (recipe % this.recipiesPerPage() == 0 && !this.getRecipeNameSub().equals("")) {
            GuiDraw.drawStringC((String)this.getRecipeNameSub(), (int)83, (int)-2, (int)0x404040, (boolean)false);
        }
    }

    protected ShapedRecipeHandler.CachedShapedRecipe getCachedRecipe(IRecipe irecipe) {
        ShapedRecipeHandler.CachedShapedRecipe recipe = null;
        if (irecipe instanceof ShapedRecipes) {
            recipe = new ShapedRecipeHandler.CachedShapedRecipe((ShapedRecipeHandler)this, (ShapedRecipes)irecipe);
        } else if (irecipe instanceof ShapedOreRecipe) {
            recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
        } else if (!(irecipe instanceof ShapelessRecipes) && !(irecipe instanceof ShapelessOreRecipe)) {
            NEIPlugins.logWarning("Unknown recipe type for {0}", irecipe.func_77571_b());
        }
        if (recipe == null) {
            return null;
        }
        for (PositionedStack stack : recipe.ingredients) {
            stack.rely += 2;
        }
        recipe.result.relx = 88;
        recipe.result.rely = 18;
        return recipe;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("railcraft.rolling")) {
            for (IRecipe irecipe : RailcraftCraftingManager.rollingMachine.getRecipeList()) {
                ShapedRecipeHandler.CachedShapedRecipe recipe = this.getCachedRecipe(irecipe);
                if (recipe == null) continue;
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : RailcraftCraftingManager.rollingMachine.getRecipeList()) {
            ShapedRecipeHandler.CachedShapedRecipe recipe = this.getCachedRecipe(irecipe);
            if (recipe == null || !recipe.contains((Collection)recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation((Collection)recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : RailcraftCraftingManager.rollingMachine.getRecipeList()) {
            ShapedRecipeHandler.CachedShapedRecipe recipe;
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result) || (recipe = this.getCachedRecipe(irecipe)) == null) continue;
            this.arecipes.add(recipe);
        }
    }
}

