/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.gadgets.MachineMoistener;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.item.ItemStack;

public class MoistenerRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle waterTank = new Rectangle(11, 5, 16, 58);
    static Point overlayTank = new Point(176, 0);
    static PositionedStack[] fuels;

    @Override
    public String getRecipeId() {
        return "forestry.moistener";
    }

    public String getRecipeName() {
        return "Moistener";
    }

    public ArrayList<MachineMoistener.Recipe> getRecipeList() {
        MachineMoistener.RecipeManager cfr_ignored_0 = (MachineMoistener.RecipeManager)RecipeManagers.moistenerManager;
        return MachineMoistener.RecipeManager.recipes;
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MachineMoistener.Recipe irecipe : this.getRecipeList()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)irecipe.product, (ItemStack)result)) continue;
            this.arecipes.add(new CachedMoistenerRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (fuels == null) {
            this.loadFuels();
        }
        MachineMoistener.RecipeManager manager = (MachineMoistener.RecipeManager)RecipeManagers.moistenerManager;
        MachineMoistener.Recipe irecipe = MachineMoistener.RecipeManager.findMatchingRecipe((ItemStack)ingredient);
        if (irecipe != null) {
            CachedMoistenerRecipe recipe = new CachedMoistenerRecipe(irecipe);
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (fuels == null) {
            this.loadFuels();
        }
        if (outputId.equals("forestry.moistener") && ((Object)((Object)this)).getClass() == MoistenerRecipeHandler.class) {
            for (MachineMoistener.Recipe irecipe : this.getRecipeList()) {
                this.arecipes.add(new CachedMoistenerRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/moistener.png";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(138, 27, 16, 14), "forestry.moistener", new Object[0]));
    }

    public void loadFuels() {
        ArrayList<ItemStack> resources = new ArrayList<ItemStack>();
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (MoistenerFuel fuel : FuelManager.moistenerResource.values()) {
            resources.add(fuel.item);
            products.add(fuel.product);
        }
        fuels = new PositionedStack[]{new PositionedStack(resources, 100, 26), new PositionedStack(products, 34, 47)};
    }

    public class CachedMoistenerRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        LiquidTank tank;
        PositionedStack resource;
        PositionedStack product;

        public CachedMoistenerRecipe(MachineMoistener.Recipe recipe) {
            super((TemplateRecipeHandler)MoistenerRecipeHandler.this);
            this.resource = new PositionedStack((Object)recipe.resource, 138, 8);
            this.product = new PositionedStack((Object)recipe.product, 138, 44);
            this.tank = new LiquidTank(LiquidHelper.getWaterFluid(), 10000, waterTank, overlayTank);
            this.tank.showAmount = false;
        }

        public PositionedStack getResult() {
            return this.product;
        }

        public PositionedStack getIngredient() {
            return this.resource;
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.tank);
            return res;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(LiquidHelper.getSeqCycledStack(MoistenerRecipeHandler.this.cycleticks / 20, fuels[0]));
            stacks.add(LiquidHelper.getSeqCycledStack(MoistenerRecipeHandler.this.cycleticks / 20, fuels[1]));
            return stacks;
        }
    }
}

