/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import buildcraft.api.power.PowerHandler;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.TilePowered;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.IFirstTickHandler;
import mods.neiplugins.common.Utils;
import mods.neiplugins.forestry.ForestryTooltipHandler;
import net.minecraft.tileentity.TileEntity;

public class ForestryOptions
implements IFirstTickHandler {
    public static boolean isloaded = false;
    public static boolean hasWorkCounter = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void loadPowerConfigFromMachineDefinition(Class cls, String field) {
        if (cls == null) {
            return;
        }
        Object obj = Utils.getField(cls, field, null);
        if (obj instanceof MachineDefinition) {
            try {
                MachineDefinition md = (MachineDefinition)obj;
                TileEntity te = md.createMachine();
                if (te instanceof TilePowered) {
                    PowerHandler pp = ((TilePowered)te).getPowerHandler();
                    if (!(pp.getActivationEnergy() > 0.0f)) return;
                    if (!hasWorkCounter) {
                        ForestryTooltipHandler.addPowerInfo(md.blockID, md.meta, "Requires %d MJ every %d ticks", Math.round(pp.getActivationEnergy()), 5);
                        return;
                    }
                    ForestryTooltipHandler.addPowerInfo(md.blockID, md.meta, "Requires %d MJ/t", Math.round(pp.getActivationEnergy()));
                    return;
                }
                NEIPlugins.logWarning("ForestryOptions.loadPowerConfigFromMachineDefinition error: {0}.{1} not define TilePowered", cls.getName(), field);
                return;
            }
            catch (Exception ex) {
                NEIPlugins.logWarningEx((String)"ForestryOptions.loadPowerConfigFromMachineDefinition error:", (Exception)ex, (Object[])new Object[0]);
                return;
            }
        } else {
            NEIPlugins.logWarning("ForestryOptions.loadPowerConfigFromMachineDefinition error: {0}.{1} not instance of MachineDefinition", cls.getName(), field);
        }
    }

    public static void loadPowerConfig() {
        if (isloaded) {
            return;
        }
        Class pluginFactory = Utils.findClass("forestry.plugins.PluginFactory");
        if (pluginFactory == null) {
            NEIPlugins.logWarning("Class forestry.plugins.PluginFactory not found", new Object[0]);
            return;
        }
        try {
            TilePowered.class.getDeclaredField("workCounter");
            hasWorkCounter = true;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        ForestryOptions.loadPowerConfigFromMachineDefinition(pluginFactory, "definitionBottler");
        ForestryOptions.loadPowerConfigFromMachineDefinition(pluginFactory, "definitionCarpenter");
        ForestryOptions.loadPowerConfigFromMachineDefinition(pluginFactory, "definitionCentrifuge");
        ForestryOptions.loadPowerConfigFromMachineDefinition(pluginFactory, "definitionFabricator");
        ForestryOptions.loadPowerConfigFromMachineDefinition(pluginFactory, "definitionFermenter");
        ForestryOptions.loadPowerConfigFromMachineDefinition(pluginFactory, "definitionSqueezer");
        ForestryOptions.loadPowerConfigFromMachineDefinition(pluginFactory, "definitionStill");
        isloaded = true;
    }

    @Override
    public boolean firstServerTick() {
        return true;
    }

    @Override
    public boolean firstClientTick() {
        ForestryOptions.loadPowerConfig();
        return true;
    }
}

