/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import forestry.api.recipes.RecipeManagers;
import forestry.core.interfaces.IDescriptiveRecipe;
import forestry.factory.gadgets.MachineCarpenter;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.Utils;
import mods.neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class CarpenterRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(145, 3, 16, 58);
    static Point overlayTank = new Point(176, 0);

    public static ItemStack getBox(MachineCarpenter.Recipe recipe) {
        return (ItemStack)ObfuscationReflectionHelper.getPrivateValue(MachineCarpenter.Recipe.class, (Object)recipe, (int)2);
    }

    @Override
    public String getRecipeId() {
        return "forestry.carpenter";
    }

    public String getRecipeName() {
        return "Carpenter";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(93, 36, 4, 18), this.getRecipeId(), new Object[0]));
    }

    public ArrayList<MachineCarpenter.Recipe> getRecipes() {
        MachineCarpenter.RecipeManager cfr_ignored_0 = (MachineCarpenter.RecipeManager)RecipeManagers.carpenterManager;
        return MachineCarpenter.RecipeManager.recipes;
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (MachineCarpenter.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(irecipe.getLiquid(), ingredient)) continue;
            this.arecipes.add(new CachedCarpenterRecipe(irecipe));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (MachineCarpenter.Recipe irecipe : this.getRecipes()) {
            this.arecipes.add(new CachedCarpenterRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MachineCarpenter.Recipe irecipe : this.getRecipes()) {
            if (!Utils.areStacksSameTypeCrafting(irecipe.getCraftingResult(), result)) continue;
            this.arecipes.add(new CachedCarpenterRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack t = LiquidHelper.getFluidStack(ingredient);
        for (MachineCarpenter.Recipe irecipe : this.getRecipes()) {
            CachedCarpenterRecipe recipe;
            if (irecipe.isIngredient(ingredient) || Utils.areStacksSameTypeCrafting(CarpenterRecipeHandler.getBox(irecipe), ingredient)) {
                recipe = new CachedCarpenterRecipe(irecipe);
                this.setIngredientPermutationNBT(recipe.ingredients, ingredient);
                this.arecipes.add(recipe);
                continue;
            }
            if (t == null || !LiquidHelper.areSameLiquid(irecipe.getLiquid(), t)) continue;
            recipe = new CachedCarpenterRecipe(irecipe);
            this.setIngredientPermutationNBT(recipe.slot_input, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)14, (int)166, (int)65);
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/carpenter.png";
    }

    public class CachedCarpenterRecipe
    extends ForestryRecipeHandler.CachedShapedRecipeCustom
    implements ICachedRecipeWithLiquidTank {
        ArrayList<PositionedStack> slot_input;
        public LiquidTank input;

        public CachedCarpenterRecipe(MachineCarpenter.Recipe recipe) {
            ItemStack box;
            super(CarpenterRecipeHandler.this);
            this.xoffset = 5;
            this.yoffset = 6;
            this.xproduct = 75;
            this.yproduct = 37;
            this.ingredients = new ArrayList();
            this.setIngredients((IDescriptiveRecipe)recipe.asIRecipe());
            this.input = new LiquidTank(recipe.getLiquid(), 10000, inputTank, overlayTank);
            this.slot_input = new ArrayList();
            if (this.input.liquid != null) {
                this.slot_input.add(LiquidHelper.generateStacksForLiquid(this.input.liquid, 115, 25, 115, 6)[1]);
            }
            if ((box = CarpenterRecipeHandler.getBox(recipe)) != null) {
                this.ingredients.add(new PositionedStack((Object)box, 78, 6));
            }
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.input);
            return res;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getCycledIngredients(CarpenterRecipeHandler.this.cycleticks / 20, this.slot_input);
        }
    }
}

