/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.forge.IContainerTooltipHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.IPlugin;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.forge.DamageValueTooltipHandler;
import mods.neiplugins.forge.FluidRegistryList;
import mods.neiplugins.forge.OptionsForge;
import mods.neiplugins.forge.OreDictionaryList;
import mods.neiplugins.forge.OreDictionaryTooltipHandler;
import net.minecraft.block.Block;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class NEIPlugins_Forge
implements IPlugin {
    public static final String PLUGIN_NAME = "Forge";
    public static final String PLUGIN_VERSION = "1.4.1";
    public static final String REQUIRED_MOD = "Forge";
    public static OreDictionaryTooltipHandler oredictTooltipHandler;
    public static DamageValueTooltipHandler damagevalTooltipHandler;

    @Override
    public String getPluginName() {
        return "Forge";
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod("Forge");
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        this.addLiquidContainerSubset();
        API.registerUsageHandler((IUsageHandler)new OreDictionaryList());
        API.registerRecipeHandler((ICraftingHandler)new OreDictionaryList());
        API.registerUsageHandler((IUsageHandler)new FluidRegistryList());
        API.registerRecipeHandler((ICraftingHandler)new FluidRegistryList());
        OreDictionaryTooltipHandler.resetCache();
        oredictTooltipHandler = new OreDictionaryTooltipHandler();
        damagevalTooltipHandler = new DamageValueTooltipHandler();
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)oredictTooltipHandler);
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)damagevalTooltipHandler);
        MultiItemRange liquids = new MultiItemRange();
        for (Block i : Block.field_71973_m) {
            if (!(i instanceof IFluidBlock)) continue;
            liquids.add(i.field_71990_ca);
        }
        API.addSetRange((String)"Blocks.Fluids", (MultiItemRange)liquids);
        OptionsForge.addOptions();
    }

    private void applyFluidLocalizationFix() {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            String unloc;
            if (!fluid.getLocalizedName().equals(fluid.getUnlocalizedName()) || !(unloc = fluid.getUnlocalizedName()).startsWith("fluid.fluid.")) continue;
            fluid.setUnlocalizedName(unloc.substring(12));
            NEIPlugins.logInfo("Change unlocalized name of liquid {0}: {1} -> {2}", fluid.getName(), unloc, unloc.substring(12));
        }
    }

    private void addLiquidContainerSubset() {
        HashSet<List<Integer>> setContainerValidation = new HashSet<List<Integer>>();
        HashMap<Integer, MultiItemRange> mapMultiItemRangeFromLiquid = new HashMap<Integer, MultiItemRange>();
        MultiItemRange containers = new MultiItemRange();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!setContainerValidation.contains(Arrays.asList(data.emptyContainer.field_77993_c, data.emptyContainer.func_77960_j()))) {
                setContainerValidation.add(Arrays.asList(data.emptyContainer.field_77993_c, data.emptyContainer.func_77960_j()));
                containers.add(data.emptyContainer);
            }
            if (data.fluid == null || data.fluid.tag != null) continue;
            MultiItemRange range = (MultiItemRange)mapMultiItemRangeFromLiquid.get(data.fluid.fluidID);
            if (range == null) {
                String liquidName = LiquidHelper.getLiquidName(data.fluid).replace('.', '_');
                range = new MultiItemRange();
                mapMultiItemRangeFromLiquid.put(data.fluid.fluidID, range);
                if (!liquidName.isEmpty()) {
                    API.addSetRange((String)("Items.Liquid Containers." + liquidName), (MultiItemRange)range);
                }
            }
            range.add(data.filledContainer);
        }
        API.addSetRange((String)"Items.Liquid Containers", (MultiItemRange)containers);
    }
}

