/*
 * Decompiled with CFR 0.152.
 */
package myrathi.infinibows.asm;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.util.List;
import myrathi.infinibows.LoadingPlugin;
import myrathi.infinibows.asm.DescriptorMapping;
import myrathi.infinibows.asm.InstructionComparator;
import myrathi.infinibows.util.IBLog;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BowTransformer
implements IClassTransformer,
Opcodes {
    private static FMLDeobfuscatingRemapper fmldr = FMLDeobfuscatingRemapper.INSTANCE;
    private static String _methodOnItemRightClick = "onItemRightClick";
    private static String _classItemStack = "net/minecraft/item/ItemStack";
    private static String _classPlayerCapabilities = "net/minecraft/entity/player/PlayerCapabilities";
    private static String _fieldIsCreativeMode = "isCreativeMode";
    private static String _classEnchantment = "net/minecraft/enchantment/Enchantment";
    private static String _fieldInfinity = "infinity";
    private static String _fieldEffectId = "effectId";
    private static String _classEnchantmentHelper = "net/minecraft/enchantment/EnchantmentHelper";
    private static String _methodGetEnchantmentLevel = "getEnchantmentLevel";

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!transformedName.equals("net.minecraft.item.ItemBow")) {
            return bytes;
        }
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 8);
        this.transformItemBow(node);
        ClassWriter writer = new ClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void transformItemBow(ClassNode classNode) {
        if (LoadingPlugin._runtimeDeobfuscationEnabled) {
            BowTransformer.setupNames();
        }
        for (MethodNode node : classNode.methods) {
            String name = fmldr.mapMethodName(classNode.name, node.name, node.desc);
            if (!name.equals(_methodOnItemRightClick)) continue;
            this.transformBowRightClick(node);
        }
    }

    private void transformBowRightClick(MethodNode node) {
        try {
            InsnList needle = new InsnList();
            needle.add((AbstractInsnNode)new DescriptorMapping(_classPlayerCapabilities, _fieldIsCreativeMode, Type.getDescriptor(Boolean.TYPE)).toFieldInsn(180));
            needle.add((AbstractInsnNode)new JumpInsnNode(154, new LabelNode()));
            List<InstructionComparator.InsnListSection> lists = InstructionComparator.insnListFindL(node.instructions, needle);
            if (lists.size() != 1) {
                IBLog.severe("Unrecognised bytecode in ItemBow.onItemRightClick - code injection failed! (N=%d)", lists.size());
                return;
            }
            InstructionComparator.InsnListSection subsection = lists.get(0);
            AbstractInsnNode inode = subsection.last;
            if (!(inode instanceof JumpInsnNode)) {
                IBLog.severe("Malformed bytecode in ItemBow.onItemRightClick - aborting code injection! (NT:%s)", inode.getClass().getName());
                return;
            }
            JumpInsnNode jnode = (JumpInsnNode)inode;
            while (inode.getOpcode() != 25) {
                inode = inode.getNext();
            }
            InsnList injectList = new InsnList();
            injectList.add((AbstractInsnNode)new DescriptorMapping(_classEnchantment, _fieldInfinity, "L" + _classEnchantment + ";").toFieldInsn(178));
            injectList.add((AbstractInsnNode)new DescriptorMapping(_classEnchantment, _fieldEffectId, Type.getDescriptor(Integer.TYPE)).toFieldInsn(180));
            injectList.add((AbstractInsnNode)new VarInsnNode(25, 1));
            String desc = String.format("(%s%s)%s", "I", "L" + _classItemStack + ";", "I");
            injectList.add((AbstractInsnNode)new DescriptorMapping(_classEnchantmentHelper, _methodGetEnchantmentLevel, desc).toInsn(184));
            injectList.add((AbstractInsnNode)new JumpInsnNode(157, new LabelNode(jnode.label.getLabel())));
            node.instructions.insertBefore(inode, injectList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IBLog.info("Fix injected.", new Object[0]);
    }

    private static void setupNames() {
        _methodOnItemRightClick = "func_77659_a";
        _classItemStack = "ye";
        _classPlayerCapabilities = "uc";
        _fieldIsCreativeMode = "d";
        _classEnchantment = "aau";
        _fieldInfinity = "y";
        _fieldEffectId = "z";
        _classEnchantmentHelper = "aaw";
        _methodGetEnchantmentLevel = "a";
    }
}

