/*
 * Decompiled with CFR 0.152.
 */
package redstonearsenal.item.tool;

import cofh.api.energy.IEnergyContainerItem;
import cofh.util.EnergyHelper;
import cofh.util.MathHelper;
import cofh.util.StringHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import redstonearsenal.core.ProxyClient;
import redstonearsenal.item.tool.IEmpowerableItem;
import redstonearsenal.util.Utils;

public class ItemSwordRF
extends ItemSword
implements IEmpowerableItem,
IEnergyContainerItem {
    Icon activeIcon;
    Icon drainedIcon;
    public int maxEnergy = 160000;
    public int maxTransfer = 1600;
    public int energyPerUse = 200;
    public int energyPerUseCharged = 800;
    public int damage = 8;
    public int damageCharged = 4;

    public ItemSwordRF(int id, EnumToolMaterial toolMaterial) {
        super(id, toolMaterial);
        this.setNoRepair();
    }

    protected int useEnergy(ItemStack stack, boolean simulate) {
        int unbreakingLevel = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack), (int)0, (int)4);
        return this.extractEnergy(stack, this.isEmpowered(stack) ? this.energyPerUseCharged * (5 - unbreakingLevel) / 5 : this.energyPerUse * (5 - unbreakingLevel) / 5, simulate);
    }

    protected int getEnergyPerUse(ItemStack stack) {
        int unbreakingLevel = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack), (int)0, (int)4);
        return (this.isEmpowered(stack) ? this.energyPerUseCharged : this.energyPerUse) * (5 - unbreakingLevel) / 5;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public void func_77633_a(int itemId, CreativeTabs tab, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(itemId, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(itemId, 1, 0), (int)this.maxEnergy));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase player) {
        float fallingMult;
        if (stack.func_77960_j() > 0) {
            stack.func_77964_b(0);
        }
        EntityPlayer thePlayer = (EntityPlayer)player;
        float f = fallingMult = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null ? 1.5f : 1.0f;
        if (thePlayer.field_71075_bZ.field_75098_d || this.useEnergy(stack, false) == this.getEnergyPerUse(stack)) {
            float fluxDamage = this.isEmpowered(stack) ? (float)this.damageCharged : 1.0f;
            float enchantDamage = (float)this.damage + EnchantmentHelper.func_77512_a((EntityLivingBase)player, (EntityLivingBase)entity);
            entity.func_70097_a(Utils.causePlayerFluxDamage(thePlayer), fluxDamage);
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)thePlayer), (fluxDamage + enchantDamage) * fallingMult);
        } else {
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)thePlayer), 1.0f * fallingMult);
        }
        return true;
    }

    public boolean func_77660_a(ItemStack stack, World world, int bId, int x, int y, int z, EntityLivingBase entity) {
        if ((double)Block.field_71973_m[bId].func_71934_m(world, x, y, z) != 0.0) {
            this.extractEnergy(stack, this.energyPerUse, false);
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (!this.isEmpowered(stack) || !isCurrentItem) {
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70632_aY()) {
            AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b(2.0, 1.0, 2.0);
            List list = entity.field_70170_p.func_72872_a(EntityMob.class, axisalignedbb);
            for (Entity mob : list) {
                this.pushEntityAway(mob, entity);
            }
        }
    }

    protected void pushEntityAway(Entity entity, Entity player) {
        double d0 = player.field_70165_t - entity.field_70165_t;
        double d1 = player.field_70161_v - entity.field_70161_v;
        double d2 = MathHelper.maxAbs((double)d0, (double)d1);
        if (d2 >= 0.01) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= 0.2;
            d1 *= 0.2;
            entity.func_70024_g(-(d0 *= (double)(1.0f - entity.field_70144_Y)), 0.0, -(d1 *= (double)(1.0f - entity.field_70144_Y)));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForInfo);
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + stack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
        list.add("\u00a76" + this.getEnergyPerUse(stack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        if (this.isEmpowered(stack)) {
            list.add("\u00a7e\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)ProxyClient.empower.field_74512_d) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.chargeOff") + "\u00a7r");
        } else {
            list.add("\u00a7b\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)ProxyClient.empower.field_74512_d) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.chargeOn") + "\u00a7r");
        }
        if (this.getEnergyStored(stack) >= this.getEnergyPerUse(stack)) {
            list.add("");
            list.add("\u00a79+" + this.damage + " " + StringHelper.localize((String)"info.cofh.damageAttack") + "\u00a7r");
            list.add("\u00a7a+" + (this.isEmpowered(stack) ? this.damageCharged : 1) + " " + StringHelper.localize((String)"info.cofh.damageFlux") + "\u00a7r");
        }
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1 + this.maxEnergy - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return 1 + this.maxEnergy;
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77960_j() != Short.MAX_VALUE;
    }

    public Multimap func_111205_h() {
        return HashMultimap.create();
    }

    public Icon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public Icon getIcon(ItemStack stack, int pass) {
        return this.isEmpowered(stack) ? this.activeIcon : (this.getEnergyStored(stack) <= 0 ? this.drainedIcon : this.field_77791_bV);
    }

    public void func_94581_a(IconRegister ir) {
        this.field_77791_bV = ir.func_94245_a(this.func_111208_A());
        this.activeIcon = ir.func_94245_a(this.func_111208_A() + "_Active");
        this.drainedIcon = ir.func_94245_a(this.func_111208_A() + "_Drained");
    }

    @Override
    public boolean isEmpowered(ItemStack stack) {
        return stack.field_77990_d == null ? false : stack.field_77990_d.func_74767_n("Empowered");
    }

    @Override
    public boolean setEmpoweredState(ItemStack stack, boolean state) {
        if (this.getEnergyStored(stack) > 0) {
            stack.field_77990_d.func_74757_a("Empowered", state);
            return true;
        }
        stack.field_77990_d.func_74757_a("Empowered", false);
        return false;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.maxEnergy - stored, this.maxTransfer));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored -= extract);
            if (stored == 0) {
                this.setEmpoweredState(container, false);
            }
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }
}

