/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import cofh.block.BlockCoFHBase;
import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.energycell.BlockEnergyCell;
import thermalexpansion.block.energycell.TileEnergyCell;
import thermalexpansion.core.TEProps;

@SideOnly(value=Side.CLIENT)
public class RenderEnergyCell
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderEnergyCell instance = new RenderEnergyCell();
    static Icon[] textureCenter = new Icon[2];
    static Icon[] textureFrame = new Icon[BlockEnergyCell.Types.values().length * 2];
    static CCModel modelCenter = CCModel.quadModel((int)24);
    static CCModel modelFrame = CCModel.quadModel((int)48);

    public static void initialize() {
        RenderEnergyCell.textureCenter[0] = IconRegistry.getIcon((String)"StorageRedstone");
        RenderEnergyCell.textureCenter[1] = IconRegistry.getIcon((String)"FluidRedstone");
        for (int i = 0; i < textureFrame.length; ++i) {
            RenderEnergyCell.textureFrame[i] = IconRegistry.getIcon((String)"Cell", (int)i);
        }
    }

    public void renderCenter(int metadata, double x, double y, double z) {
        if (metadata == 1 || metadata == 2) {
            modelCenter.render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureCenter[0]));
        } else {
            modelCenter.render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureCenter[1]));
        }
    }

    public void renderFrame(int metadata, TileEnergyCell tile, double x, double y, double z) {
        int i;
        Translation trans = RenderUtils.getRenderVector((double)x, (double)y, (double)z).translation();
        for (i = 0; i < 6; ++i) {
            modelFrame.render(i * 4, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureFrame[2 * metadata]), null);
            modelFrame.render(i * 4 + 24, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureFrame[2 * metadata + 1]), null);
        }
        if (tile != null) {
            for (i = 0; i < 6; ++i) {
                modelFrame.render(i * 4, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)tile.getBlockTexture(i, 2)), null);
            }
            int facing = tile.getFacing();
            modelFrame.render(facing * 4, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)tile.getBlockTexture(facing, 3)), null);
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int chargeLevel = 9;
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        this.renderFrame(metadata, null, -0.5, -0.5, -0.5);
        CCRenderState.draw();
        CCRenderState.startDrawing((int)7);
        CCRenderState.setBrightness((int)(165 + chargeLevel * 5));
        this.renderCenter(metadata, -0.5, -0.5, -0.5);
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        GL11.glDisable((int)3042);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileEnergyCell)) {
            return false;
        }
        TileEnergyCell theTile = (TileEnergyCell)tile;
        int chargeLevel = Math.min(15, theTile.getScaledEnergyStored(16));
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (BlockCoFHBase.renderPass == 0) {
            this.renderFrame(theTile.type, theTile, x, y, z);
        } else {
            CCRenderState.setBrightness((int)(165 + chargeLevel * 5));
            this.renderCenter(theTile.type, x, y, z);
        }
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdEnergyCell;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        double offset = -0.5;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            offset = 0.0;
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.setBlockTextureSheet();
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        if (item.func_77960_j() == 64) {
            instance.renderFrame(BlockEnergyCell.Types.BASIC.ordinal(), null, offset, offset, offset);
            instance.renderCenter(BlockEnergyCell.Types.BASIC.ordinal(), offset, offset, offset);
        } else if (item.func_77960_j() == 72) {
            instance.renderFrame(BlockEnergyCell.Types.REINFORCED.ordinal(), null, offset, offset, offset);
        } else if (item.func_77960_j() == 73) {
            instance.renderFrame(BlockEnergyCell.Types.REINFORCED.ordinal(), null, offset, offset, offset);
            instance.renderCenter(BlockEnergyCell.Types.REINFORCED.ordinal(), offset, offset, offset);
        }
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        RenderHelper.setItemTextureSheet();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    static {
        TEProps.renderIdEnergyCell = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        modelCenter.generateBlock(0, 0.15, 0.15, 0.15, 0.85, 0.85, 0.85).computeNormals();
        Cuboid6 box = new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        double inset = 0.1875;
        modelFrame = CCModel.quadModel((int)48).generateBlock(0, box);
        CCModel.generateBackface((CCModel)modelFrame, (int)0, (CCModel)modelFrame, (int)24, (int)24);
        modelFrame.computeNormals();
        for (int i = 24; i < 48; ++i) {
            RenderEnergyCell.modelFrame.verts[i].vec.add(RenderEnergyCell.modelFrame.normals[i].copy().multiply(inset));
        }
        modelFrame.computeLighting(LightModel.standardLightModel);
    }
}

