/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.item.tool;

import cofh.api.energy.IEnergyContainerItem;
import cofh.util.CoreUtils;
import cofh.util.EnergyHelper;
import cofh.util.StringHelper;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.item.ItemTEBase;

public class ItemCapacitor
extends ItemTEBase
implements IEnergyContainerItem {
    public static final int[] SEND = new int[]{5000, 20, 20, 100, 500, 2500};
    public static final int[] RECEIVE = new int[]{0, 0, 80, 400, 2000, 10000};
    public static final int[] STORAGE = new int[]{5000, 16000, 80000, 400000, 2000000, 10000000};

    public static ItemStack setDefaultTag(ItemStack container, int energy) {
        container.func_77982_d(new NBTTagCompound());
        container.field_77990_d.func_74768_a("Energy", energy);
        return container;
    }

    public ItemCapacitor(int id) {
        super(id);
        this.func_77656_e(1);
        this.func_77625_d(1);
        this.func_77637_a(ThermalExpansion.tabTools);
    }

    public boolean isActive(ItemStack stack) {
        return stack.field_77990_d == null ? false : stack.field_77990_d.func_74767_n("Active");
    }

    public boolean setActiveState(ItemStack stack, boolean state) {
        if (this.getEnergyStored(stack) > 0) {
            stack.field_77990_d.func_74757_a("Active", state);
            return true;
        }
        stack.field_77990_d.func_74757_a("Active", false);
        return false;
    }

    public void func_77633_a(int itemId, CreativeTabs tab, List list) {
        list.add(ItemCapacitor.setDefaultTag(new ItemStack(itemId, 1, Types.CREATIVE.ordinal()), STORAGE[Types.CREATIVE.ordinal()]));
        list.add(ItemCapacitor.setDefaultTag(new ItemStack(itemId, 1, Types.POTATO.ordinal()), STORAGE[Types.POTATO.ordinal()]));
        for (int i = 2; i < Types.values().length; ++i) {
            list.add(ItemCapacitor.setDefaultTag(new ItemStack(itemId, 1, i), 0));
            list.add(ItemCapacitor.setDefaultTag(new ItemStack(itemId, 1, i), STORAGE[i]));
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (CoreUtils.isFakePlayer((EntityPlayer)player)) {
            return stack;
        }
        if (player.func_70093_af() && this.setActiveState(stack, !this.isActive(stack))) {
            if (this.isActive(stack)) {
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.2f, 0.8f);
            } else {
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.2f, 0.5f);
            }
        }
        player.func_71038_i();
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int hitSide, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (slot > 8 || !this.isActive(stack) || isCurrentItem) {
            return;
        }
        InventoryPlayer playerInv = ((EntityPlayer)entity).field_71071_by;
        int toSend = Math.min(this.getEnergyStored(stack), SEND[stack.func_77960_j()]);
        if (EnergyHelper.isEnergyContainerItem((ItemStack)playerInv.func_70448_g())) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem)playerInv.field_70462_a[playerInv.field_70461_c].func_77973_b();
            this.extractEnergy(stack, containerItem.receiveEnergy(playerInv.field_70462_a[playerInv.field_70461_c], toSend, false), false);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isActive(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForInfo);
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.field_77990_d == null) {
            ItemCapacitor.setDefaultTag(stack, 0);
        }
        if (stack.func_77960_j() == Types.CREATIVE.ordinal()) {
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.localize((String)"info.cofh.infinite"));
            list.add(StringHelper.localize((String)"info.cofh.send") + ": " + SEND[stack.func_77960_j()] + " RF/t");
        } else {
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((int)stack.field_77990_d.func_74762_e("Energy")) + " / " + StringHelper.getScaledNumber((int)STORAGE[stack.func_77960_j()]) + " RF");
            list.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + SEND[stack.func_77960_j()] + "/" + RECEIVE[stack.func_77960_j()] + " RF/t");
        }
        if (this.isActive(stack)) {
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor3"));
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor5"));
            list.add(StringHelper.getDeactivationText((String)"info.thermalexpansion.capacitor4"));
        } else {
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor1"));
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor5"));
            list.add(StringHelper.getActivationText((String)"info.thermalexpansion.capacitor2"));
        }
        if (stack.func_77960_j() == Types.POTATO.ordinal()) {
            list.add(StringHelper.getFlavorText((String)"info.thermalexpansion.capacitor.potato"));
        }
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return 1 + STORAGE[stack.func_77960_j()];
        }
        return 1 + STORAGE[stack.func_77960_j()] - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return 1 + STORAGE[stack.func_77960_j()];
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77960_j() != Types.CREATIVE.ordinal();
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77960_j() <= Types.POTATO.ordinal()) {
            return 0;
        }
        if (container.field_77990_d == null) {
            ItemCapacitor.setDefaultTag(container, 0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(STORAGE[container.func_77960_j()] - stored, RECEIVE[container.func_77960_j()]));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null) {
            ItemCapacitor.setDefaultTag(container, 0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int extract = Math.min(maxExtract, Math.min(stored, SEND[container.func_77960_j()]));
        if (!simulate && container.func_77960_j() != Types.CREATIVE.ordinal()) {
            container.field_77990_d.func_74768_a("Energy", stored -= extract);
            if (stored == 0 && container.func_77960_j() == Types.POTATO.ordinal()) {
                container.field_77993_c = Item.field_82795_bM.field_77779_bT;
                container.func_77964_b(0);
                container.field_77990_d = null;
            }
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null) {
            ItemCapacitor.setDefaultTag(container, 0);
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return STORAGE[container.func_77960_j()];
    }

    public static enum Types {
        CREATIVE,
        POTATO,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

