/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.fluid;

import cofh.util.BlockHelper;
import cofh.util.ItemHelper;
import cofh.util.ServerHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.fluid.BlockFluidInteractive;
import thermalexpansion.fluid.TEFluids;
import thermalexpansion.util.DamageSources;

public class BlockFluidCryotheum
extends BlockFluidInteractive {
    public static boolean enableSourceFall = true;

    public BlockFluidCryotheum(int id) {
        super(id, TEFluids.fluidCryotheum, TEFluids.materialFluidCryotheum, "cryotheum");
        this.setQuantaPerBlock(5);
        this.setTickRate(30);
        this.func_71848_c(1000.0f);
        this.func_71868_h(1);
        this.setParticleColor(0.15f, 0.7f, 1.0f);
        this.addInteraction((Block)Block.field_71980_u, Block.field_71979_v);
        this.addInteraction(Block.field_71943_B, Block.field_72036_aT);
        this.addInteraction((Block)Block.field_71942_A, Block.field_72039_aU);
        this.addInteraction(Block.field_71938_D, Block.field_72089_ap);
        this.addInteraction((Block)Block.field_71944_C, Block.field_71978_w);
        this.addInteraction((Block)Block.field_71952_K, null);
        this.addInteraction((Block)Block.field_71962_X, null);
        this.addInteraction((Block)Block.field_72067_ar, null);
        this.addInteraction(TEFluids.blockGlowstone.field_71990_ca, 0, Block.field_72014_bd.field_71990_ca, 0);
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        if (!TEFluids.effectCryotheum) {
            return;
        }
        if (entity.field_70181_x < -0.05 || entity.field_70181_x > 0.05) {
            entity.field_70181_x *= 0.05;
        }
        if (entity.field_70179_y < -0.05 || entity.field_70179_y > 0.05) {
            entity.field_70179_y *= 0.05;
        }
        if (entity.field_70159_w < -0.05 || entity.field_70159_w > 0.05) {
            entity.field_70159_w *= 0.05;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L != 0L) {
            return;
        }
        if (entity instanceof EntityZombie || entity instanceof EntityCreeper) {
            entity.func_70106_y();
            EntitySnowman snowman = new EntitySnowman(world);
            snowman.func_70012_b((double)x + 0.5, (double)y + 1.0, (double)z + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)snowman);
        } else if (entity instanceof EntityBlaze) {
            entity.func_70097_a((DamageSource)DamageSources.cryotheum, 10.0f);
        } else {
            entity.func_70097_a((DamageSource)DamageSources.cryotheum, 2.0f);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return TEFluids.fluidCryotheum.getLuminosity();
    }

    public void func_71861_g(World world, int x, int y, int z) {
        world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
    }

    public void func_71863_a(World world, int x, int y, int z, int blockId) {
        world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        if (TEFluids.effectCryotheum) {
            this.checkForInteraction(world, x, y, z);
        }
        if (world.func_72805_g(x, y, z) == 0) {
            int bId = world.func_72798_a(x, y + this.densityDir, z);
            int bMeta = world.func_72805_g(x, y + this.densityDir, z);
            if (bId == this.field_71990_ca && bMeta != 0) {
                world.func_72832_d(x, y + this.densityDir, z, this.field_71990_ca, 0, 3);
                world.func_94571_i(x, y, z);
                return;
            }
        }
        super.func_71847_b(world, x, y, z, rand);
    }

    protected void checkForInteraction(World world, int x, int y, int z) {
        if (world.func_72798_a(x, y, z) != this.field_71990_ca) {
            return;
        }
        int x2 = x;
        int y2 = y;
        int z2 = z;
        int result = -1;
        for (int i = 0; i < 6; ++i) {
            x2 = x + BlockHelper.SIDE_COORD_MOD[i][0];
            y2 = y + BlockHelper.SIDE_COORD_MOD[i][1];
            z2 = z + BlockHelper.SIDE_COORD_MOD[i][2];
            this.interactWithBlock(world, x2, y2, z2);
            this.interactWithBlock(world, x2 += BlockHelper.SIDE_COORD_MOD[i][0], y2, z2 += BlockHelper.SIDE_COORD_MOD[i][2]);
        }
        this.interactWithBlock(world, x - 1, y, z - 1);
        this.interactWithBlock(world, x - 1, y, z + 1);
        this.interactWithBlock(world, x + 1, y, z - 1);
        this.interactWithBlock(world, x + 1, y, z + 1);
    }

    protected void interactWithBlock(World world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        if (bId == 0) {
            return;
        }
        int bMeta = world.func_72805_g(x, y, z);
        int result = -1;
        if (this.hasInteraction(bId, bMeta)) {
            result = this.getInteraction(bId, bMeta);
            world.func_72832_d(x, y, z, ItemHelper.getIDFromHashCode((int)result), ItemHelper.getMetaFromHashCode((int)result), 3);
        } else if (world.isBlockSolidOnSide(x, y, z, ForgeDirection.UP) && world.func_72799_c(x, y + 1, z)) {
            world.func_72832_d(x, y + 1, z, Block.field_72037_aS.field_71990_ca, 0, 3);
        }
    }

    protected void triggerInteractionEffects(World world, int x, int y, int z) {
    }
}

