/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.plate;

import buildcraft.api.tools.IToolWrench;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.render.IconRegistry;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.plate.TilePlateBase;
import thermalexpansion.block.plate.TilePlateImpulse;
import thermalexpansion.block.plate.TilePlateSignal;
import thermalexpansion.block.plate.TilePlateTranslocate;
import thermalexpansion.core.TEProps;
import thermalexpansion.util.Utils;

public class BlockPlate
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"signal", "impulse", "translocate"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack signalPlate;
    public static ItemStack impulsePlate;
    public static ItemStack translocatePlate;

    public BlockPlate(int id) {
        super(id, Material.field_76243_f);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0635f, 1.0f);
        this.func_71848_c(15.0f);
        this.func_71894_b(25.0f);
        this.func_71864_b("thermalexpansion.plate");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= Types.values().length) {
            return null;
        }
        switch (Types.values()[metadata]) {
            case SIGNAL: {
                return new TilePlateSignal();
            }
            case IMPULSE: {
                return new TilePlateImpulse();
            }
            case TRANSLOCATE: {
                return new TilePlateTranslocate();
            }
        }
        return null;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int hitSide, float hitX, float hitY, float hitZ) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (player.func_70093_af()) {
            if (Utils.isHoldingUsableWrench(player, x, y, z)) {
                if (ServerHelper.isServerWorld((World)world)) {
                    this.dismantleBlock(player, world, x, y, z, false);
                    ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
                }
                return true;
            }
            return false;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return true;
        }
        TileEntity theTile = world.func_72796_p(x, y, z);
        if (theTile instanceof IReconfigurableFacing && Utils.isHoldingUsableWrench(player, x, y, z)) {
            ((IReconfigurableFacing)theTile).rotateBlock();
            ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        TileEntity theTile = world.func_72796_p(x, y, z);
        if (theTile instanceof IReconfigurableFacing) {
            int quadrant = MathHelper.func_76128_c((double)((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (quadrant) {
                case 0: {
                    ((IReconfigurableFacing)theTile).setFacing(3);
                    return;
                }
                case 1: {
                    ((IReconfigurableFacing)theTile).setFacing(4);
                    return;
                }
                case 2: {
                    ((IReconfigurableFacing)theTile).setFacing(2);
                    return;
                }
                case 3: {
                    ((IReconfigurableFacing)theTile).setFacing(5);
                    return;
                }
            }
        }
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        TilePlateBase tile = (TilePlateBase)world.func_72796_p(x, y, z);
        if (tile == null) {
            return;
        }
        tile.onEntityCollidedWithBlock(entity);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)y + 0.0625, (double)(z + 1));
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        return world.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP);
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        return this.func_71854_d(world, x, y, z);
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 vec3d, Vec3 vec3d1) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71878_a(world, x, y, z, vec3d, vec3d1);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        float maxY = 0.0625f;
        TilePlateBase theTile = (TilePlateBase)world.func_72796_p(x, y, z);
        if (theTile != null && theTile.alignment < 2) {
            maxY = 0.125f;
        }
        this.func_71905_a(-0.01f, -0.01f, -0.01f, 1.01f, maxY, 1.01f);
    }

    public int func_71857_b() {
        return TEProps.renderIdPlate;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        IconRegistry.addIcon((String)"PlateBottom", (String)"thermalexpansion:plate/Plate_Bottom", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop0", (String)"thermalexpansion:plate/Plate_Top_Down", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop1", (String)"thermalexpansion:plate/Plate_Top_Up", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop2", (String)"thermalexpansion:plate/Plate_Top_North", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop3", (String)"thermalexpansion:plate/Plate_Top_South", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop4", (String)"thermalexpansion:plate/Plate_Top_West", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop5", (String)"thermalexpansion:plate/Plate_Top_East", (IconRegister)ir);
    }

    public boolean initialize() {
        TilePlateSignal.initialize();
        TilePlateImpulse.initialize();
        TilePlateTranslocate.initialize();
        signalPlate = new ItemStack((Block)this, 1, Types.SIGNAL.ordinal());
        impulsePlate = new ItemStack((Block)this, 1, Types.IMPULSE.ordinal());
        translocatePlate = new ItemStack((Block)this, 1, Types.TRANSLOCATE.ordinal());
        GameRegistry.registerCustomItemStack((String)"plateSignal", (ItemStack)signalPlate);
        GameRegistry.registerCustomItemStack((String)"plateImpulse", (ItemStack)impulsePlate);
        GameRegistry.registerCustomItemStack((String)"plateTranslocate", (ItemStack)translocatePlate);
        return true;
    }

    public boolean postInit() {
        return true;
    }

    static {
        String category = "block.feature";
        BlockPlate.enable[Types.SIGNAL.ordinal()] = ThermalExpansion.config.get(category, "Plate.Signal", true);
        BlockPlate.enable[Types.IMPULSE.ordinal()] = ThermalExpansion.config.get(category, "Plate.Impulse", true);
        BlockPlate.enable[Types.TRANSLOCATE.ordinal()] = ThermalExpansion.config.get(category, "Plate.Translocate", true);
    }

    public static enum Types {
        SIGNAL,
        IMPULSE,
        TRANSLOCATE;

    }
}

