/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.network.Payload;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.core.TEProps;

public class TileRockGen
extends TileMachineBase
implements IFluidHandler {
    public static final int TYPE = BlockMachine.Types.ROCK_GEN.ordinal();
    public static int[] processLava = new int[]{0, 0, 1000};
    public static int[] processWater = new int[]{0, 1000, 1000};
    public static int[] processTime = new int[]{40, 80, 120};
    static ItemStack[] processItems = new ItemStack[3];
    FluidTank lavaTank = new FluidTank(4000);
    FluidTank waterTank = new FluidTank(4000);
    byte curSelection;
    byte prevSelection;
    int outputTracker;

    public static void initialize() {
        TileRockGen.processItems[0] = new ItemStack(Block.field_71978_w);
        TileRockGen.processItems[1] = new ItemStack(Block.field_71981_t);
        TileRockGen.processItems[2] = new ItemStack(Block.field_72089_ap);
        String category = "tweak.crafting";
        TileRockGen.processLava[0] = MathHelper.clampI((int)ThermalExpansion.config.get(category, "RockGen.Cobblestone.Lava", processLava[0]), (int)0, (int)4000);
        TileRockGen.processLava[1] = MathHelper.clampI((int)ThermalExpansion.config.get(category, "RockGen.Stone.Lava", processLava[1]), (int)0, (int)4000);
        TileRockGen.processLava[2] = MathHelper.clampI((int)ThermalExpansion.config.get(category, "RockGen.Obsidian.Lava", processLava[2]), (int)0, (int)4000);
        TileRockGen.processWater[0] = MathHelper.clampI((int)ThermalExpansion.config.get(category, "RockGen.Cobblestone.Water", processWater[0]), (int)0, (int)4000);
        TileRockGen.processWater[1] = MathHelper.clampI((int)ThermalExpansion.config.get(category, "RockGen.Stone.Water", processWater[1]), (int)0, (int)4000);
        TileRockGen.processWater[2] = MathHelper.clampI((int)ThermalExpansion.config.get(category, "RockGen.Obsidian.Water", processWater[2]), (int)0, (int)4000);
        TileRockGen.processTime[0] = MathHelper.clampI((int)ThermalExpansion.config.get(category, "RockGen.Cobblestone.Time", processTime[0]), (int)4, (int)72000);
        TileRockGen.processTime[1] = MathHelper.clampI((int)ThermalExpansion.config.get(category, "RockGen.Stone.Time", processTime[1]), (int)4, (int)72000);
        TileRockGen.processTime[2] = MathHelper.clampI((int)ThermalExpansion.config.get(category, "RockGen.Obsidian.Time", processTime[2]), (int)4, (int)72000);
        TileRockGen.sideData[TileRockGen.TYPE] = new TileMachineBase.SideConfig();
        TileRockGen.sideData[TileRockGen.TYPE].numGroup = 3;
        TileRockGen.sideData[TileRockGen.TYPE].slotGroups = new int[][]{new int[0], new int[0], {0}};
        TileRockGen.sideData[TileRockGen.TYPE].allowInsertion = new boolean[]{false, true, false};
        TileRockGen.sideData[TileRockGen.TYPE].allowExtraction = new boolean[]{false, false, true};
        TileRockGen.sideData[TileRockGen.TYPE].sideTex = new int[]{0, 1, 4};
        TileRockGen.guiIds[TileRockGen.TYPE] = ThermalExpansion.proxy.registerGui("RockGen", "machine", true);
        GameRegistry.registerTileEntity(TileRockGen.class, (String)"cofh.thermalexpansion.RockGen");
    }

    public TileRockGen() {
        this.sideCache = new byte[]{2, 2, 1, 1, 1, 1};
        this.inventory = new ItemStack[4];
        this.inventory[1] = processItems[0];
        this.inventory[2] = processItems[1];
        this.inventory[3] = processItems[2];
    }

    public int getType() {
        return TYPE;
    }

    public boolean canStart() {
        if (this.lavaTank.getFluidAmount() < 1000 || this.waterTank.getFluidAmount() < 1000) {
            return false;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(processItems[this.curSelection])) {
            return false;
        }
        return this.inventory[0].field_77994_a + TileRockGen.processItems[this.curSelection].field_77994_a <= processItems[this.curSelection].func_77976_d();
    }

    public boolean canFinish() {
        return this.processRem <= 0;
    }

    protected void processStart() {
        this.processRem = this.processMax = processTime[this.curSelection];
        this.prevSelection = this.curSelection;
    }

    protected void processFinish() {
        if (this.inventory[0] == null) {
            this.inventory[0] = processItems[this.prevSelection].func_77946_l();
        } else {
            this.inventory[0].field_77994_a += TileRockGen.processItems[this.prevSelection].field_77994_a;
        }
        this.lavaTank.drain(processLava[this.prevSelection], true);
        this.waterTank.drain(processWater[this.prevSelection], true);
        this.prevSelection = this.curSelection;
    }

    protected void transferProducts() {
        if (this.inventory[0] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.transferItem(0, 4, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    public void func_70316_g() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.processRem > 0) {
                --this.processRem;
            } else if (this.canFinish()) {
                this.processFinish();
                this.transferProducts();
                this.processRem = this.processMax;
                if (this.redstoneControlOrDisable() && this.canStart()) {
                    this.processStart();
                } else {
                    this.isActive = false;
                    this.wasActive = true;
                    this.tracker.markTime(this.field_70331_k);
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferProducts();
            }
            if (this.timeCheckEighth() && this.canStart()) {
                this.processStart();
                --this.processRem;
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
    }

    @Override
    public Payload getModePayload() {
        Payload payload = super.getModePayload();
        payload.addByte(this.curSelection);
        return payload;
    }

    public void setMode(int i) {
        this.curSelection = (byte)i;
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.sendModePacket();
        }
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.isActive = payload.getBool();
                this.processMax = payload.getInt();
                this.processRem = payload.getInt();
                return;
            }
            case MODE: {
                this.curSelection = payload.getByte();
                if (!this.isActive) {
                    this.prevSelection = this.curSelection;
                }
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
                return;
            }
        }
    }

    public int getCurSelection() {
        return this.curSelection;
    }

    public int getPrevSelection() {
        return this.prevSelection;
    }

    public FluidTank getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.lavaTank;
        }
        return this.waterTank;
    }

    public FluidStack getTankFluid(int tankIndex) {
        if (tankIndex == 0) {
            return this.lavaTank.getFluid();
        }
        return this.waterTank.getFluid();
    }

    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.curSelection = (byte)j;
            }
            case 1: {
                this.prevSelection = (byte)j;
                return;
            }
            case 2: {
                if (this.lavaTank.getFluid() == null) {
                    this.lavaTank.setFluid(new FluidStack(FluidRegistry.LAVA, j));
                } else {
                    this.lavaTank.getFluid().amount = j;
                }
                return;
            }
            case 3: {
                if (this.waterTank.getFluid() == null) {
                    this.waterTank.setFluid(new FluidStack(FluidRegistry.WATER, j));
                } else {
                    this.waterTank.getFluid().amount = j;
                }
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        super.sendGuiNetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, 0, (int)this.curSelection);
        iCrafting.func_71112_a(container, 1, (int)this.prevSelection);
        iCrafting.func_71112_a(container, 2, this.lavaTank.getFluidAmount());
        iCrafting.func_71112_a(container, 3, this.waterTank.getFluidAmount());
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.outputTracker = nbt.func_74762_e("Tracker");
        this.prevSelection = nbt.func_74771_c("Prev");
        this.curSelection = nbt.func_74771_c("Sel");
        this.lavaTank.readFromNBT(nbt.func_74775_l("LavaTank"));
        this.waterTank.readFromNBT(nbt.func_74775_l("WaterTank"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Tracker", this.outputTracker);
        nbt.func_74774_a("Prev", this.prevSelection);
        nbt.func_74774_a("Sel", this.curSelection);
        nbt.func_74782_a("LavaTank", (NBTBase)this.lavaTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("WaterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.length - 3;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 1) {
            return 0;
        }
        if (resource.getFluid() == FluidRegistry.LAVA) {
            return this.lavaTank.fill(resource, doFill);
        }
        if (resource.getFluid() == FluidRegistry.WATER) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.lavaTank.getInfo(), this.waterTank.getInfo()};
    }
}

