/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block;

import cofh.network.ITilePacketHandler;
import cofh.network.Payload;
import cofh.util.BlockHelper;
import cofh.util.ServerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.util.Utils;

public abstract class TileInventory
extends TileTEBase
implements IInventory,
ITilePacketHandler {
    public ItemStack[] inventory = new ItemStack[0];
    protected String invName = "";
    TileEntity curTile;

    public boolean transferItem(int slot, int amount, int side) {
        if (this.inventory[slot] == null || slot > this.inventory.length) {
            return false;
        }
        ItemStack stack = this.inventory[slot].func_77946_l();
        stack.field_77994_a = amount = Math.min(amount, stack.field_77994_a);
        this.curTile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)side);
        if (Utils.isInventory(this.curTile, side)) {
            this.inventory[slot].field_77994_a -= amount - Utils.addToInventory(this.curTile, side, stack);
            if (this.inventory[slot].field_77994_a <= 0) {
                this.inventory[slot] = null;
            }
            return true;
        }
        if (Utils.isPipeTile(this.curTile)) {
            this.inventory[slot].field_77994_a -= Utils.addToPipeTile(this.curTile, side, stack);
            if (this.inventory[slot].field_77994_a <= 0) {
                this.inventory[slot] = null;
            }
            return true;
        }
        return false;
    }

    public boolean setInvName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        this.invName = name;
        return true;
    }

    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addString(this.invName);
        return payload;
    }

    public void handleTilePacket(Payload payload) {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.invName = payload.getString();
        } else {
            payload.getString();
        }
    }

    public int getInvSlotCount() {
        return this.inventory.length;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        if (nbt.func_74764_b("Name")) {
            this.invName = nbt.func_74779_i("Name");
        }
        this.readInventoryFromNBT(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (!this.invName.isEmpty()) {
            nbt.func_74778_a("Name", this.invName);
        }
        this.writeInventoryToNBT(nbt);
    }

    public void readInventoryFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_74761_m("Inventory");
        this.inventory = new ItemStack[this.inventory.length];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)list.func_74743_b(i);
            int slot = tag.func_74762_e("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void writeInventoryToNBT(NBTTagCompound nbt) {
        if (this.inventory.length <= 0) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            this.inventory[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Inventory", (NBTBase)list);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] == null) {
            return null;
        }
        if (this.inventory[slot].field_77994_a <= amount) {
            amount = this.inventory[slot].field_77994_a;
        }
        ItemStack stack = this.inventory[slot].func_77979_a(amount);
        if (this.inventory[slot].field_77994_a <= 0) {
            this.inventory[slot] = null;
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] == null) {
            return null;
        }
        ItemStack stack = this.inventory[slot];
        this.inventory[slot] = null;
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return this.invName.isEmpty() ? this.getName() : this.invName;
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isUseable(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }
}

