/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.core.multiblock.rectangular;

import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import erogenousbeef.core.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class RectangularMultiblockControllerBase
extends MultiblockControllerBase {
    protected RectangularMultiblockControllerBase(World world) {
        super(world);
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException("Machine is too small.");
        }
        CoordTriplet maximumCoord = this.getMaximumCoord();
        CoordTriplet minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.x - minimumCoord.x + 1;
        int deltaY = maximumCoord.y - minimumCoord.y + 1;
        int deltaZ = maximumCoord.z - minimumCoord.z + 1;
        int maxX = this.getMaximumXSize();
        int maxY = this.getMaximumYSize();
        int maxZ = this.getMaximumZSize();
        int minX = this.getMinimumXSize();
        int minY = this.getMinimumYSize();
        int minZ = this.getMinimumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the X dimension", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Y dimension", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Z dimension", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the X dimension", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Y dimension", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Z dimension", minZ));
        }
        for (int x = minimumCoord.x; x <= maximumCoord.x; ++x) {
            for (int y = minimumCoord.y; y <= maximumCoord.y; ++y) {
                for (int z = minimumCoord.z; z <= maximumCoord.z; ++z) {
                    TileEntity te = this.worldObj.func_72796_p(x, y, z);
                    RectangularMultiblockTileEntityBase part = te instanceof RectangularMultiblockTileEntityBase ? (RectangularMultiblockTileEntityBase)te : null;
                    int extremes = 0;
                    if (x == minimumCoord.x) {
                        ++extremes;
                    }
                    if (y == minimumCoord.y) {
                        ++extremes;
                    }
                    if (z == minimumCoord.z) {
                        ++extremes;
                    }
                    if (x == maximumCoord.x) {
                        ++extremes;
                    }
                    if (y == maximumCoord.y) {
                        ++extremes;
                    }
                    if (z == maximumCoord.z) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        if (part != null) {
                            part.isGoodForFrame();
                            continue;
                        }
                        this.isBlockGoodForFrame(this.worldObj, x, y, z);
                        continue;
                    }
                    if (extremes == 1) {
                        if (y == maximumCoord.y) {
                            if (part != null) {
                                part.isGoodForTop();
                                continue;
                            }
                            this.isBlockGoodForTop(this.worldObj, x, y, z);
                            continue;
                        }
                        if (y == minimumCoord.y) {
                            if (part != null) {
                                part.isGoodForBottom();
                                continue;
                            }
                            this.isBlockGoodForBottom(this.worldObj, x, y, z);
                            continue;
                        }
                        if (part != null) {
                            part.isGoodForSides();
                            continue;
                        }
                        this.isBlockGoodForSides(this.worldObj, x, y, z);
                        continue;
                    }
                    if (part != null) {
                        part.isGoodForInterior();
                        continue;
                    }
                    this.isBlockGoodForInterior(this.worldObj, x, y, z);
                }
            }
        }
    }
}

