/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.world;

import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class BRSimpleOreGenerator
extends WorldGenMinable {
    protected int blockToGenerate;
    protected int blockToGenerateMetadata;
    protected int field_94523_c;
    protected int minClustersPerChunk;
    protected int maxClustersPerChunk;
    protected int minY;
    protected int maxY;
    protected Set<Integer> dimensionBlacklist;

    public BRSimpleOreGenerator(int blockToGenerate, int blockMetadata, int blockToReplace, int clustersPerChunk, int maxY, int maxOrePerCluster) {
        super(blockToGenerate, blockMetadata, maxOrePerCluster, blockToReplace);
        this.minClustersPerChunk = this.maxClustersPerChunk = clustersPerChunk;
        this.minY = 0;
        this.maxY = maxY;
        this.blockToGenerate = blockToGenerate;
        this.blockToGenerateMetadata = blockMetadata;
        this.field_94523_c = blockToReplace;
        this.dimensionBlacklist = new CopyOnWriteArraySet<Integer>();
    }

    public BRSimpleOreGenerator(int blockToGenerate, int blockMetadata, int blockToReplace, int minClustersPerChunk, int maxClustersPerChunk, int minY, int maxY, int maxOrePerCluster) {
        this(blockToGenerate, blockMetadata, blockToReplace, maxClustersPerChunk, maxY, maxOrePerCluster);
        this.minClustersPerChunk = minClustersPerChunk;
        this.minY = minY;
    }

    public void blacklistDimension(int dimensionId) {
        this.dimensionBlacklist.add(dimensionId);
    }

    public void generateChunk(World world, Random random, int chunkX, int chunkZ) {
        int clustersToGen = this.minClustersPerChunk;
        if (this.maxClustersPerChunk > this.minClustersPerChunk) {
            clustersToGen += random.nextInt(this.maxClustersPerChunk - this.minClustersPerChunk);
        }
        int chunkBaseX = chunkX << 4;
        int chunkBaseZ = chunkZ << 4;
        for (int i = 0; i < clustersToGen; ++i) {
            int y = this.minY + random.nextInt(this.maxY - this.minY);
            this.func_76484_a(world, random, chunkBaseX, y, chunkBaseZ);
        }
    }

    public boolean shouldGenerateInWorld(World world) {
        IChunkProvider chunkProvider = world.func_72863_F();
        if (this.dimensionBlacklist.contains(world.field_73011_w.field_76574_g)) {
            return false;
        }
        if (chunkProvider instanceof ChunkProviderHell) {
            return false;
        }
        return !(chunkProvider instanceof ChunkProviderEnd);
    }

    public boolean equals(Object o) {
        if (o instanceof BRSimpleOreGenerator) {
            BRSimpleOreGenerator other = (BRSimpleOreGenerator)((Object)o);
            if (this.blockToGenerate >= 0) {
                return this.blockToGenerate == other.blockToGenerate && this.blockToGenerateMetadata == other.blockToGenerateMetadata;
            }
            if (other.blockToGenerate >= 0) {
                return false;
            }
            return false;
        }
        return false;
    }
}

