/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls.grab;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.client.gui.GuiReactorRedNetPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.grab.BeefGuiGrabTarget;
import erogenousbeef.bigreactors.gui.controls.grab.IBeefGuiGrabbable;
import erogenousbeef.bigreactors.gui.controls.grab.RedNetConfigGrabbable;

public class RedNetConfigGrabTarget
extends BeefGuiGrabTarget
implements IBeefTooltipControl {
    TileEntityReactorRedNetPort port;
    int channel;
    String tooltip;
    TileEntityReactorRedNetPort.CircuitType currentCircuitType;

    public RedNetConfigGrabTarget(BeefGuiBase container, int x, int y, TileEntityReactorRedNetPort port, int channel) {
        super(container, x, y);
        this.port = port;
        this.channel = channel;
        this.tooltip = null;
        this.currentCircuitType = port.getChannelCircuitType(channel);
    }

    @Override
    public void onSlotCleared() {
        this.currentCircuitType = TileEntityReactorRedNetPort.CircuitType.DISABLED;
        this.tooltip = null;
        if (this.guiContainer instanceof GuiReactorRedNetPort) {
            ((GuiReactorRedNetPort)this.guiContainer).onChannelChanged(this.channel);
        }
    }

    @Override
    public void onSlotSet() {
        this.currentCircuitType = ((RedNetConfigGrabbable)this.grabbable).GetCircuitType();
        this.tooltip = ((RedNetConfigGrabbable)this.grabbable).getName();
        if (this.guiContainer instanceof GuiReactorRedNetPort) {
            ((GuiReactorRedNetPort)this.guiContainer).onChannelChanged(this.channel);
        }
    }

    @Override
    public boolean isAcceptedGrab(IBeefGuiGrabbable grabbedItem) {
        return grabbedItem instanceof RedNetConfigGrabbable;
    }

    public boolean hasChanged() {
        return this.currentCircuitType != this.port.getChannelCircuitType(this.channel);
    }

    public int getChannel() {
        return this.channel;
    }

    public TileEntityReactorRedNetPort.CircuitType getCircuitType() {
        return this.currentCircuitType;
    }

    @Override
    public String[] getTooltip() {
        return new String[]{this.tooltip};
    }
}

