/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.interfaces.IMultipleFluidHandler;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiIconProgressBar;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class BeefGuiFluidBar
extends BeefGuiIconProgressBar
implements IBeefTooltipControl {
    IMultipleFluidHandler _entity;
    int tankIdx;

    public BeefGuiFluidBar(BeefGuiBase container, int x, int y, IMultipleFluidHandler entity, int tankIdx) {
        super(container, x, y);
        this._entity = entity;
        this.tankIdx = tankIdx;
    }

    @Override
    protected Icon getProgressBarIcon() {
        FluidTankInfo[] tanks = this._entity.getTankInfo();
        if (tanks != null && this.tankIdx < tanks.length && tanks[this.tankIdx].fluid != null) {
            return tanks[this.tankIdx].fluid.getFluid().getIcon();
        }
        return null;
    }

    @Override
    protected float getProgress() {
        FluidStack tankFluid;
        FluidTankInfo[] tanks = this._entity.getTankInfo();
        if (tanks != null && this.tankIdx < tanks.length && (tankFluid = tanks[this.tankIdx].fluid) != null) {
            return (float)tankFluid.amount / (float)tanks[this.tankIdx].capacity;
        }
        return 0.0f;
    }

    @Override
    public String[] getTooltip() {
        if (!this.visible) {
            return null;
        }
        FluidTankInfo[] tanks = this._entity.getTankInfo();
        if (tanks != null && this.tankIdx < tanks.length) {
            FluidStack tankFluid = tanks[this.tankIdx].fluid;
            if (tankFluid != null) {
                String fluidName = tankFluid.getFluid().getLocalizedName();
                if (tankFluid.getFluid().getID() == FluidRegistry.WATER.getID()) {
                    fluidName = "Water";
                } else if (tankFluid.getFluid().getID() == FluidRegistry.LAVA.getID()) {
                    fluidName = "Lava";
                }
                return new String[]{fluidName, String.format("%d / %d mB", tankFluid.amount, tanks[this.tankIdx].capacity)};
            }
            return new String[]{"Empty", String.format("0 / %d mB", tanks[this.tankIdx].capacity)};
        }
        return null;
    }

    @Override
    protected ResourceLocation getResourceLocation() {
        return TextureMap.field_110575_b;
    }

    @Override
    protected boolean drawGradationMarks() {
        return true;
    }
}

