/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity.base;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileEntityPoweredInventory
extends TileEntityInventory
implements IEnergyHandler {
    public static float energyPerRF = 1.0f;
    private int cycledTicks = -1;
    private EnergyStorage energyStorage = new EnergyStorage(this.getMaxEnergyStored());

    protected abstract int getMaxEnergyStored();

    public abstract int getCycleEnergyCost();

    public abstract int getCycleLength();

    public abstract boolean canBeginCycle();

    public abstract void onPoweredCycleBegin();

    public abstract void onPoweredCycleEnd();

    public int getCurrentCycleTicks() {
        return this.cycledTicks;
    }

    public boolean isActive() {
        return this.cycledTicks >= 0;
    }

    public float getCycleCompletion() {
        if (this.cycledTicks < 0) {
            return 0.0f;
        }
        return (float)this.cycledTicks / (float)this.getCycleLength();
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        if (tag.func_74764_b("energyStorage")) {
            this.energyStorage.readFromNBT(tag.func_74775_l("energyStorage"));
        }
        if (tag.func_74764_b("cycledTicks")) {
            this.cycledTicks = tag.func_74762_e("cycledTicks");
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyTag);
        tag.func_74766_a("energyStorage", energyTag);
        tag.func_74768_a("cycledTicks", this.cycledTicks);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.cycledTicks >= 0) {
                ++this.cycledTicks;
                if (!this.canBeginCycle()) {
                    this.cycledTicks = -1;
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                } else if (this.cycledTicks >= this.getCycleLength()) {
                    this.onPoweredCycleEnd();
                    this.cycledTicks = -1;
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            }
            if (this.cycledTicks < 0 && this.getCycleEnergyCost() <= this.energyStorage.getEnergyStored() && this.canBeginCycle()) {
                this.energyStorage.extractEnergy(this.getCycleEnergyCost(), false);
                this.cycledTicks = 0;
                this.onPoweredCycleBegin();
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    @Override
    protected void onSendUpdate(NBTTagCompound updateTag) {
        super.onSendUpdate(updateTag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyTag);
        updateTag.func_74766_a("energyStorage", energyTag);
        updateTag.func_74768_a("cycledTicks", this.cycledTicks);
    }

    @Override
    public void onReceiveUpdate(NBTTagCompound updateTag) {
        super.onReceiveUpdate(updateTag);
        this.energyStorage.readFromNBT(updateTag.func_74775_l("energyStorage"));
        this.cycledTicks = updateTag.func_74762_e("cycledTicks");
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }
}

