/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity.base;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import erogenousbeef.bigreactors.gui.IBeefGuiEntity;
import erogenousbeef.bigreactors.net.PacketWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileEntityBeefBase
extends TileEntity
implements IBeefGuiEntity {
    private Set<EntityPlayer> updatePlayers;
    private int ticksSinceLastUpdate = 0;
    private static final int ticksBetweenUpdates = 3;
    private static final int[][] ROTATION_MATRIX = new int[][]{{0, 1, 2, 3, 5, 4}, {0, 1, 2, 3, 5, 4}, {0, 1, 2, 3, 5, 4}, {0, 1, 3, 2, 4, 5}, {0, 1, 4, 5, 2, 3}, {0, 1, 5, 4, 3, 2}};
    ForgeDirection forwardFace = ForgeDirection.NORTH;

    public TileEntityBeefBase() {
        this.updatePlayers = new HashSet<EntityPlayer>();
    }

    public ForgeDirection getFacingDirection() {
        return this.forwardFace;
    }

    public void rotateTowards(ForgeDirection newDirection) {
        if (this.forwardFace == newDirection) {
            return;
        }
        this.forwardFace = newDirection;
        if (!this.field_70331_k.field_72995_K) {
            Packet250CustomPayload updatePacket = PacketWrapper.createPacket("BigReactors", 5, new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n, newDirection.ordinal()});
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)updatePacket);
        }
    }

    public int getRotatedSide(int side) {
        if (side == 0 || side == 1) {
            return side;
        }
        return ROTATION_MATRIX[this.forwardFace.ordinal()][side];
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        int rotation = tag.func_74762_e("rotation");
        this.forwardFace = ForgeDirection.getOrientation((int)rotation);
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74768_a("rotation", this.forwardFace.ordinal());
    }

    public Packet func_70319_e() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_70310_b(tagCompound);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, tagCompound);
    }

    public void onDataPacket(INetworkManager network, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.updatePlayers.size() > 0) {
            ++this.ticksSinceLastUpdate;
            if (this.ticksSinceLastUpdate >= 3) {
                this.sendUpdatePacket();
                this.ticksSinceLastUpdate = 0;
            }
        }
    }

    @Override
    public void beginUpdatingPlayer(EntityPlayer player) {
        this.updatePlayers.add(player);
        this.sendUpdatePacketToClient(player);
    }

    @Override
    public void stopUpdatingPlayer(EntityPlayer player) {
        this.updatePlayers.remove(player);
    }

    protected Packet getUpdatePacket() {
        NBTTagCompound childData = new NBTTagCompound();
        this.onSendUpdate(childData);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(4);
            data.writeInt(this.field_70329_l);
            data.writeInt(this.field_70330_m);
            data.writeInt(this.field_70327_n);
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)childData);
            data.writeShort((short)abyte.length);
            data.write(abyte);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload newPacket = new Packet250CustomPayload();
        newPacket.field_73630_a = "BigReactors";
        newPacket.field_73629_c = bytes.toByteArray();
        newPacket.field_73628_b = newPacket.field_73629_c.length;
        return newPacket;
    }

    private void sendUpdatePacketToClient(EntityPlayer recipient) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        PacketDispatcher.sendPacketToPlayer((Packet)this.getUpdatePacket(), (Player)((Player)recipient));
    }

    private void sendUpdatePacket() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.updatePlayers.size() <= 0) {
            return;
        }
        Packet data = this.getUpdatePacket();
        for (EntityPlayer player : this.updatePlayers) {
            PacketDispatcher.sendPacketToPlayer((Packet)data, (Player)((Player)player));
        }
    }

    protected void onSendUpdate(NBTTagCompound updateTag) {
    }

    public void onReceiveUpdate(NBTTagCompound updateTag) {
    }

    @Override
    public abstract void onReceiveGuiButtonPress(String var1, DataInputStream var2) throws IOException;
}

