/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.api.IHeatEntity;
import erogenousbeef.bigreactors.api.IRadiationModerator;
import erogenousbeef.bigreactors.common.data.RadiationData;
import erogenousbeef.bigreactors.common.data.RadiationPacket;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.interfaces.IMultiblockGuiHandler;
import erogenousbeef.bigreactors.common.multiblock.interfaces.IMultiblockNetworkHandler;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.InventoryPlayer;

public abstract class TileEntityReactorPartBase
extends RectangularMultiblockTileEntityBase
implements IMultiblockNetworkHandler,
IMultiblockGuiHandler,
IHeatEntity,
IRadiationModerator {
    public MultiblockReactor getReactorController() {
        return (MultiblockReactor)this.getMultiblockController();
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public MultiblockControllerBase createNewMultiblock() {
        return new MultiblockReactor(this.field_70331_k);
    }

    @Override
    public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
        return MultiblockReactor.class;
    }

    @Override
    public void onNetworkPacket(int packetType, DataInputStream data) throws IOException {
        if (!this.isConnected()) {
            return;
        }
        if (packetType == 0) {
            boolean newValue = data.readBoolean();
            this.getReactorController().setActive(newValue);
        }
        if (packetType == 10) {
            int newSetting = data.readInt();
            this.getReactorController().setWasteEjection(MultiblockReactor.WasteEjectionSetting.values()[newSetting]);
        }
        if (packetType == 9) {
            boolean isFuelButton = data.readBoolean();
            boolean dumpAll = data.readBoolean();
            CoordTriplet destination = null;
            if (data.readBoolean()) {
                destination = new CoordTriplet(data.readInt(), data.readInt(), data.readInt());
            }
            if (isFuelButton) {
                this.getReactorController().ejectFuel(dumpAll, destination);
            } else {
                this.getReactorController().ejectWaste(dumpAll, destination);
            }
        }
        if (packetType == 1) {
            this.getReactorController().receiveReactorUpdate(data);
        }
    }

    @Override
    public Object getContainer(InventoryPlayer inventoryPlayer) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiElement(InventoryPlayer inventoryPlayer) {
        return null;
    }

    @Override
    public float getHeat() {
        if (!this.isConnected()) {
            return 0.0f;
        }
        return this.getReactorController().getFuelHeat();
    }

    @Override
    public float getThermalConductivity() {
        return 0.6f;
    }

    @Override
    public void moderateRadiation(RadiationData data, RadiationPacket radiation) {
        radiation.intensity = 0.0f;
    }
}

