/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.api.IHeatEntity;
import erogenousbeef.bigreactors.api.IRadiationModerator;
import erogenousbeef.bigreactors.common.BRRegistry;
import erogenousbeef.bigreactors.common.data.RadiationData;
import erogenousbeef.bigreactors.common.data.RadiationPacket;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.helpers.RadiationHelper;
import erogenousbeef.bigreactors.common.multiblock.helpers.ReactorInteriorData;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import erogenousbeef.core.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityReactorFuelRod
extends TileEntityReactorPartBase
implements IRadiationModerator,
IHeatEntity {
    @Override
    public void moderateRadiation(RadiationData data, RadiationPacket radiation) {
        if (!this.isConnected()) {
            return;
        }
        MultiblockReactor reactor = this.getReactorController();
        float heat = reactor.getFuelHeat();
        int maxY = reactor.getMaximumCoord().y;
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l, maxY, this.field_70327_n);
        if (!(te instanceof TileEntityReactorControlRod)) {
            return;
        }
        float controlRodInsertion = Math.min(1.0f, Math.max(0.0f, (float)((TileEntityReactorControlRod)te).getControlRodInsertion() / 100.0f));
        float baseAbsorption = (float)(1.0 - 0.95 * Math.exp(-10.0 * Math.exp(-0.0022 * (double)heat))) * (1.0f - radiation.hardness / this.getFuelHardnessDivisor());
        float scaledAbsorption = Math.min(1.0f, baseAbsorption * this.getFuelAbsorptionCoefficient());
        float controlRodBonus = (1.0f - scaledAbsorption) * controlRodInsertion * 0.5f;
        float controlRodPenalty = scaledAbsorption * controlRodInsertion * 0.5f;
        float radiationAbsorbed = (scaledAbsorption + controlRodBonus) * radiation.intensity;
        float fertilityAbsorbed = (scaledAbsorption - controlRodPenalty) * radiation.intensity;
        float fuelModerationFactor = this.getFuelModerationFactor();
        fuelModerationFactor += fuelModerationFactor * controlRodInsertion + controlRodInsertion;
        radiation.intensity = Math.max(0.0f, radiation.intensity - radiationAbsorbed);
        radiation.hardness /= fuelModerationFactor;
        data.fuelRfChange += radiationAbsorbed * 10.0f;
        data.fuelAbsorbedRadiation += fertilityAbsorbed;
    }

    private float getFuelModerationFactor() {
        return 1.5f;
    }

    private float getFuelAbsorptionCoefficient() {
        return 0.5f;
    }

    private float getFuelHardnessDivisor() {
        return 1.0f;
    }

    @Override
    public float getThermalConductivity() {
        return 1.0f;
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - fuel rods may only be placed in the reactor interior", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - fuel rods may only be placed in the reactor interior", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - fuel rods may only be placed in the reactor interior", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - fuel rods may only be placed in the reactor interior", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        TileEntity entityAbove = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
        if (!(entityAbove instanceof TileEntityReactorFuelRod) && !(entityAbove instanceof TileEntityReactorControlRod)) {
            throw new MultiblockValidationException(String.format("Fuel rod at %d, %d, %d must be part of a vertical column that reaches the entire height of the reactor, with a control rod on top.", this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
        TileEntity entityBelow = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (entityBelow instanceof TileEntityReactorFuelRod) {
            return;
        }
        if (entityBelow instanceof RectangularMultiblockTileEntityBase) {
            ((RectangularMultiblockTileEntityBase)entityBelow).isGoodForBottom();
            return;
        }
        throw new MultiblockValidationException(String.format("Fuel rod at %d, %d, %d must be part of a vertical column that reaches the entire height of the reactor, with a control rod on top.", this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    public float getHeatTransferRate() {
        float heatTransferRate = 0.0f;
        for (ForgeDirection dir : StaticUtils.CardinalDirections) {
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
            if (te instanceof TileEntityReactorFuelRod) continue;
            if (te instanceof IHeatEntity) {
                heatTransferRate += ((IHeatEntity)te).getThermalConductivity();
                continue;
            }
            if (this.field_70331_k.func_72799_c(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ)) {
                heatTransferRate += 0.05f;
                continue;
            }
            int blockID = this.field_70331_k.func_72798_a(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
            int metadata = this.field_70331_k.func_72805_g(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
            heatTransferRate += this.getConductivityFromBlock(blockID, metadata);
        }
        return heatTransferRate;
    }

    private float getConductivityFromBlock(int blockID, int metadata) {
        ReactorInteriorData interiorData = null;
        if (blockID == Block.field_72083_ai.field_71990_ca) {
            interiorData = BRRegistry.getReactorInteriorBlockData("blockIron");
        } else if (blockID == Block.field_72105_ah.field_71990_ca) {
            interiorData = BRRegistry.getReactorInteriorBlockData("blockGold");
        } else if (blockID == Block.field_72071_ax.field_71990_ca) {
            interiorData = BRRegistry.getReactorInteriorBlockData("blockDiamond");
        } else if (blockID == Block.field_72076_bV.field_71990_ca) {
            interiorData = BRRegistry.getReactorInteriorBlockData("blockEmerald");
        } else {
            Fluid fluid;
            Block b;
            int oreID = OreDictionary.getOreID((ItemStack)new ItemStack(blockID, 1, metadata));
            if (oreID >= 0) {
                interiorData = BRRegistry.getReactorInteriorBlockData(OreDictionary.getOreName((int)oreID));
            } else if (blockID < Block.field_71973_m.length && (b = Block.field_71973_m[blockID]) instanceof IFluidBlock && (fluid = ((IFluidBlock)b).getFluid()) != null) {
                interiorData = BRRegistry.getReactorInteriorFluidData(fluid.getName());
            }
        }
        if (interiorData == null) {
            interiorData = RadiationHelper.airData;
        }
        return interiorData.heatConductivity;
    }
}

