/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.multiblock.helpers.CoolantContainer;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityReactorCoolantPort
extends TileEntityReactorPart
implements IFluidHandler,
INeighborUpdatableEntity,
ITickableMultiblockPart {
    boolean inlet = true;
    IFluidHandler pumpDestination = null;
    private static FluidTankInfo[] emptyTankArray = new FluidTankInfo[0];

    public boolean isInlet() {
        return this.inlet;
    }

    public void setInlet(boolean shouldBeInlet) {
        if (this.inlet == shouldBeInlet) {
            return;
        }
        this.inlet = shouldBeInlet;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!this.inlet && !this.field_70331_k.field_72995_K) {
            this.checkForAdjacentTank();
        }
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("inlet", this.inlet);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        if (packetData.func_74764_b("inlet")) {
            this.setInlet(packetData.func_74767_n("inlet"));
        }
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockControllerBase) {
        super.onMachineAssembled(multiblockControllerBase);
        this.checkForAdjacentTank();
        if (this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        this.pumpDestination = null;
        if (this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        if (tag.func_74764_b("inlet")) {
            this.inlet = tag.func_74767_n("inlet");
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74757_a("inlet", this.inlet);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.isConnected() || !this.inlet || from != this.getOutwardsDir()) {
            return 0;
        }
        CoolantContainer cc = this.getReactorController().getCoolantContainer();
        return cc.fill(this.getConnectedTank(), resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return null;
        }
        CoolantContainer cc = this.getReactorController().getCoolantContainer();
        return cc.drain(this.getConnectedTank(), resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return null;
        }
        CoolantContainer cc = this.getReactorController().getCoolantContainer();
        return cc.drain(this.getConnectedTank(), maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return false;
        }
        if (!this.inlet) {
            return false;
        }
        CoolantContainer cc = this.getReactorController().getCoolantContainer();
        return cc.canFill(this.getConnectedTank(), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return false;
        }
        CoolantContainer cc = this.getReactorController().getCoolantContainer();
        return cc.canDrain(this.getConnectedTank(), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return emptyTankArray;
        }
        CoolantContainer cc = this.getReactorController().getCoolantContainer();
        return cc.getTankInfo(this.getConnectedTank());
    }

    @Override
    public void onMultiblockServerTick() {
        if (this.pumpDestination == null || this.isInlet()) {
            return;
        }
        CoolantContainer cc = this.getReactorController().getCoolantContainer();
        FluidStack fluidToDrain = cc.drain(0, cc.getCapacity(), false);
        if (fluidToDrain != null && fluidToDrain.amount > 0) {
            fluidToDrain.amount = this.pumpDestination.fill(this.getOutwardsDir().getOpposite(), fluidToDrain, true);
            cc.drain(0, fluidToDrain, true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int neighborBlockID) {
        this.checkForAdjacentTank();
    }

    private int getConnectedTank() {
        if (this.inlet) {
            return 1;
        }
        return 0;
    }

    protected void checkForAdjacentTank() {
        this.pumpDestination = null;
        if (this.field_70331_k.field_72995_K || this.isInlet()) {
            return;
        }
        ForgeDirection outDir = this.getOutwardsDir();
        if (outDir == ForgeDirection.UNKNOWN) {
            return;
        }
        TileEntity neighbor = this.field_70331_k.func_72796_p(this.field_70329_l + outDir.offsetX, this.field_70330_m + outDir.offsetY, this.field_70327_n + outDir.offsetZ);
        if (neighbor instanceof IFluidHandler) {
            this.pumpDestination = (IFluidHandler)neighbor;
        }
    }
}

