/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.common.BRLoader;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.tileentity.TileEntityCyaniteReprocessor;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityBeefBase;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityInventory;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityPoweredInventory;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityPoweredInventoryFluid;
import erogenousbeef.bigreactors.utils.StaticUtils;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockBRSmallMachine
extends BlockContainer {
    public static final int META_CYANITE_REPROCESSOR = 0;
    public static final String[] _subBlocks = new String[]{"cyaniteReprocessor"};
    private Icon[] _icons = new Icon[_subBlocks.length];
    private Icon[] _activeIcons = new Icon[_subBlocks.length];
    private Icon[] _inventorySideIcons = new Icon[3];
    private Icon[] _fluidSideIcons = new Icon[2];

    public BlockBRSmallMachine(int id, Material material) {
        super(id, material);
        this.func_71884_a(field_71977_i);
        this.func_71848_c(1.0f);
        this.func_71864_b("blockBRSmallMachine");
        this.func_111022_d("bigreactors:blockBRSmallMachine");
        this.func_71849_a(BigReactors.TAB);
    }

    public Icon getIconFromTileEntity(TileEntity te, int metadata, int side) {
        TileEntityPoweredInventoryFluid fluidTe;
        int tank;
        int[] slots;
        if (metadata < 0) {
            return this.field_94336_cN;
        }
        if (te instanceof TileEntityBeefBase && side == ((TileEntityBeefBase)te).getFacingDirection().ordinal()) {
            if (te instanceof TileEntityPoweredInventory && ((TileEntityPoweredInventory)te).isActive()) {
                if (metadata >= this._activeIcons.length) {
                    BRLog.warning("Block at %d, %d, %d has invalid metadata (%d)", te.field_70329_l, te.field_70330_m, te.field_70327_n, metadata);
                    return this.field_94336_cN;
                }
                return this._activeIcons[metadata];
            }
            if (metadata >= this._icons.length) {
                BRLog.warning("Block at %d, %d, %d has invalid metadata (%d)", te.field_70329_l, te.field_70330_m, te.field_70327_n, metadata);
                return this.field_94336_cN;
            }
            return this._icons[metadata];
        }
        if (te instanceof TileEntityInventory && (slots = ((TileEntityInventory)te).func_94128_d(side)) != null && slots.length > 0 && slots[0] != -1) {
            return this._inventorySideIcons[slots[0]];
        }
        if (te instanceof TileEntityPoweredInventoryFluid && (tank = (fluidTe = (TileEntityPoweredInventoryFluid)te).getExposedTankFromReferenceSide(ForgeDirection.getOrientation((int)fluidTe.getRotatedSide(side)))) != -1) {
            return this._fluidSideIcons[tank];
        }
        return this.field_94336_cN;
    }

    public Icon func_71895_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_72796_p(x, y, z);
        int metadata = blockAccess.func_72805_g(x, y, z);
        return this.getIconFromTileEntity(te, metadata, side);
    }

    public Icon func_71858_a(int side, int metadata) {
        if (side == 4) {
            return this._icons[metadata];
        }
        return this.field_94336_cN;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.field_94336_cN = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a());
        for (int i = 0; i < _subBlocks.length; ++i) {
            this._icons[i] = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + "." + _subBlocks[i]);
            this._activeIcons[i] = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + "." + _subBlocks[i] + ".active");
        }
        this._inventorySideIcons[0] = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + ".redPort");
        this._inventorySideIcons[1] = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + ".greenPort");
        this._inventorySideIcons[2] = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + ".openPort");
        this._fluidSideIcons[0] = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + ".bluePort");
        this._fluidSideIcons[1] = par1IconRegister.func_94245_a("bigreactors:" + this.func_71917_a() + ".fluidTank2");
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileEntityCyaniteReprocessor();
            }
        }
        throw new IllegalArgumentException("Unknown metadata for tile entity");
    }

    public boolean func_71926_d() {
        return true;
    }

    public boolean func_71886_c() {
        return true;
    }

    public int func_71899_b(int metadata) {
        return metadata;
    }

    public ItemStack getCyaniteReprocessorItemStack() {
        return new ItemStack(this.field_71990_ca, 1, 0);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getCyaniteReprocessorItemStack());
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te == null) {
            return false;
        }
        if (entityPlayer.func_70093_af()) {
            if (entityPlayer.field_71071_by.func_70448_g() == null && te instanceof TileEntityBeefBase) {
                ForgeDirection newFacing = this.getDirectionFacingEntity((Entity)entityPlayer);
                ((TileEntityBeefBase)te).rotateTowards(newFacing);
                return true;
            }
            return false;
        }
        if (te instanceof TileEntityBeefBase && StaticUtils.Inventory.isPlayerHoldingWrench(entityPlayer)) {
            ForgeDirection newFacing = this.getDirectionFacingEntity((Entity)entityPlayer);
            ((TileEntityBeefBase)te).rotateTowards(newFacing);
            return true;
        }
        if (te instanceof IFluidHandler && FluidContainerRegistry.isEmptyContainer((ItemStack)entityPlayer.field_71071_by.func_70448_g())) {
            FluidTankInfo[] infoz;
            IFluidHandler fluidHandler = (IFluidHandler)te;
            for (FluidTankInfo info : infoz = fluidHandler.getTankInfo(ForgeDirection.UNKNOWN)) {
                if (!StaticUtils.Fluids.fillContainerFromTank(world, fluidHandler, entityPlayer, info.fluid)) continue;
                return true;
            }
        } else if (te instanceof IFluidHandler && FluidContainerRegistry.isFilledContainer((ItemStack)entityPlayer.field_71071_by.func_70448_g()) && StaticUtils.Fluids.fillTankWithContainer(world, (IFluidHandler)te, entityPlayer)) {
            return true;
        }
        if (te instanceof TileEntityBeefBase) {
            if (!world.field_72995_K) {
                entityPlayer.openGui((Object)BRLoader.instance, 0, world, x, y, z);
            }
            return true;
        }
        return false;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (entity == null) {
            return;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (stack.func_77978_p() != null) {
            stack.func_77978_p().func_74768_a("x", x);
            stack.func_77978_p().func_74768_a("y", y);
            stack.func_77978_p().func_74768_a("z", z);
            te.func_70307_a(stack.func_77978_p());
        }
        if (te != null && te instanceof TileEntityBeefBase) {
            ForgeDirection newFacing = this.getDirectionFacingEntity((Entity)entity);
            ((TileEntityBeefBase)te).rotateTowards(newFacing);
        }
    }

    protected ForgeDirection getDirectionFacingEntity(Entity entity) {
        int facingAngle = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (facingAngle) {
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.NORTH;
    }

    public void func_71852_a(World world, int x, int y, int z, int blockId, int meta) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack == null) continue;
                float xOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float yOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float zOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int amountToDrop = world.field_73012_v.nextInt(21) + 10;
                    if (amountToDrop > itemstack.field_77994_a) {
                        amountToDrop = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= amountToDrop;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new ItemStack(itemstack.field_77993_c, amountToDrop, itemstack.func_77960_j()));
                    if (itemstack.func_77978_p() != null) {
                        entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p());
                    }
                    float motionMultiplier = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * motionMultiplier + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_71852_a(world, x, y, z, blockId, meta);
    }
}

