/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.renderer;

import erogenousbeef.bigreactors.client.renderer.RotorSimpleRenderer;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.helpers.RotorInfo;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBearing;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.common.CoordTriplet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RotorSpecialRenderer
extends TileEntitySpecialRenderer {
    RenderBlocks renderBlocks = new RenderBlocks();

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntityTurbineRotorBearing bearing = (TileEntityTurbineRotorBearing)tileentity;
        if (bearing == null || !bearing.isConnected()) {
            return;
        }
        MultiblockTurbine turbine = bearing.getTurbine();
        if (!(turbine.isAssembled() && turbine.isActive() && turbine.hasGlass())) {
            return;
        }
        Integer displayList = bearing.getDisplayList();
        ForgeDirection rotorDir = bearing.getOutwardsDir().getOpposite();
        if (displayList == null) {
            RotorInfo info = bearing.getRotorInfo();
            displayList = this.generateRotor(info);
            bearing.setDisplayList(displayList);
        }
        float angle = bearing.getAngle();
        float speed = turbine.getRotorSpeed();
        if (speed > 0.001f) {
            angle += speed / 400.0f;
            bearing.setAngle(angle %= 360.0f);
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        this.func_110628_a(TextureMap.field_110575_b);
        GL11.glTranslated((double)(x + (double)rotorDir.offsetX), (double)(y + (double)rotorDir.offsetY), (double)(z + (double)rotorDir.offsetZ));
        if (rotorDir.offsetX != 0) {
            GL11.glTranslated((double)0.0, (double)0.5, (double)0.5);
        } else if (rotorDir.offsetY != 0) {
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
        } else if (rotorDir.offsetZ != 0) {
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.0);
        }
        GL11.glRotatef((float)angle, (float)rotorDir.offsetX, (float)rotorDir.offsetY, (float)rotorDir.offsetZ);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glCallList((int)displayList);
        GL11.glEnable((int)2896);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    int generateRotor(RotorInfo rotorInfo) {
        int list = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)list, (int)4864);
        ForgeDirection rotorDir = rotorInfo.rotorDirection;
        int rotorLen = rotorInfo.rotorLength;
        CoordTriplet currentRotorCoord = new CoordTriplet(0, 0, 0);
        Tessellator tessellator = Tessellator.field_78398_a;
        if (rotorDir.offsetX != 0) {
            tessellator.func_78373_b(0.0, -0.5, -0.5);
        } else if (rotorDir.offsetY != 0) {
            tessellator.func_78373_b(-0.5, 0.0, -0.5);
        } else {
            tessellator.func_78373_b(-0.5, -0.5, 0.0);
        }
        tessellator.func_78382_b();
        tessellator.func_78380_c(256);
        tessellator.func_78376_a(255, 255, 255);
        CoordTriplet bladeCoord = new CoordTriplet(0, 0, 0);
        boolean[] hasBlades = new boolean[4];
        ForgeDirection[] bladeDirs = StaticUtils.neighborsBySide[rotorInfo.rotorDirection.ordinal()];
        for (int rotorIdx = 0; rotorIdx < rotorInfo.rotorLength; ++rotorIdx) {
            for (int i = 0; i < hasBlades.length; ++i) {
                hasBlades[i] = rotorInfo.bladeLengths[rotorIdx][i] > 0;
            }
            RotorSimpleRenderer.renderRotorShaft((Block)BigReactors.blockTurbineRotorPart, this.renderBlocks, 0, rotorDir, hasBlades, currentRotorCoord.x, currentRotorCoord.y, currentRotorCoord.z, false);
            for (int bladeIdx = 0; bladeIdx < bladeDirs.length; ++bladeIdx) {
                bladeCoord.copy(currentRotorCoord);
                bladeCoord.translate(bladeDirs[bladeIdx]);
                for (int bladeLen = 0; bladeLen < rotorInfo.bladeLengths[rotorIdx][bladeIdx]; ++bladeLen) {
                    RotorSimpleRenderer.renderBlade(this.renderBlocks, bladeCoord.x, bladeCoord.y, bladeCoord.z, (Block)BigReactors.blockTurbineRotorPart, 1, rotorInfo.rotorDirection);
                    bladeCoord.translate(bladeDirs[bladeIdx]);
                }
            }
            currentRotorCoord.translate(rotorDir);
        }
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEndList();
        return list;
    }
}

