/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import erogenousbeef.bigreactors.client.ClientProxy;
import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartBase;
import erogenousbeef.bigreactors.gui.controls.BeefGuiFluidBar;
import erogenousbeef.bigreactors.gui.controls.BeefGuiIcon;
import erogenousbeef.bigreactors.gui.controls.BeefGuiLabel;
import erogenousbeef.bigreactors.gui.controls.BeefGuiPowerBar;
import erogenousbeef.bigreactors.gui.controls.BeefGuiRpmBar;
import erogenousbeef.bigreactors.gui.controls.GuiIconButton;
import erogenousbeef.bigreactors.net.PacketWrapper;
import erogenousbeef.core.common.CoordTriplet;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.ResourceLocation;

public class GuiTurbineController
extends BeefGuiBase {
    TileEntityTurbinePartBase part;
    MultiblockTurbine turbine;
    private BeefGuiLabel titleString;
    private BeefGuiLabel statusString;
    private BeefGuiIcon speedIcon;
    private BeefGuiLabel speedString;
    private BeefGuiIcon energyGeneratedIcon;
    private BeefGuiLabel energyGeneratedString;
    private BeefGuiIcon rotorEfficiencyIcon;
    private BeefGuiLabel rotorEfficiencyString;
    private BeefGuiIcon powerIcon;
    private BeefGuiPowerBar powerBar;
    private BeefGuiIcon steamIcon;
    private BeefGuiFluidBar steamBar;
    private BeefGuiIcon waterIcon;
    private BeefGuiFluidBar waterBar;
    private BeefGuiIcon rpmIcon;
    private BeefGuiRpmBar rpmBar;
    private BeefGuiLabel governorString;
    private GuiIconButton btnGovernorUp;
    private GuiIconButton btnGovernorDown;
    private GuiIconButton btnActivate;
    private GuiIconButton btnDeactivate;
    private GuiIconButton btnVentAll;
    private GuiIconButton btnVentOverflow;
    private GuiIconButton btnVentNone;

    public GuiTurbineController(Container container, TileEntityTurbinePartBase part) {
        super(container);
        this.part = part;
        this.turbine = part.getTurbine();
    }

    @Override
    public ResourceLocation getGuiBackground() {
        return new ResourceLocation("bigreactors:textures/gui/TurbineController.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int leftX = this.field_74198_m + 4;
        int topY = this.field_74197_n + 4;
        this.titleString = new BeefGuiLabel(this, "Turbine Control", leftX, topY);
        this.speedIcon = new BeefGuiIcon(this, leftX + 1, topY += this.titleString.getHeight() + 4, 16, 16, ClientProxy.GuiIcons.getIcon("rpm"), new String[]{"\u00a7bRotor Speed", "", "Speed of the rotor in", "revolutions per minute.", "", "Rotors perform best at 900", "or 1800 RPM.", "", "Speeds over 2000PM are overspeed", "and may cause a turbine to", "fail catastrophically."});
        this.speedString = new BeefGuiLabel(this, "", leftX + 22, topY + 4);
        this.energyGeneratedIcon = new BeefGuiIcon(this, leftX + 1, topY += this.speedIcon.getHeight() + 4, 16, 16, ClientProxy.GuiIcons.getIcon("energyOutput"), new String[]{"\u00a7bEnergy Output", "", "Turbines generate energy via", "metal induction coils placed", "around a spinning rotor.", "More, or higher-quality, coils", "generate energy faster."});
        this.energyGeneratedString = new BeefGuiLabel(this, "", leftX + 22, topY + 4);
        this.rotorEfficiencyIcon = new BeefGuiIcon(this, leftX + 1, topY += this.energyGeneratedIcon.getHeight() + 4, 16, 16, ClientProxy.GuiIcons.getIcon("rotorEfficiency"), new String[]{"\u00a7bRotor Efficiency", "", "Rotor blades can only fully", String.format("capture energy from %d mB of", 25), "fluid per blade.", "", "Efficiency drops if the flow", "of input fluid rises past", "capacity."});
        this.rotorEfficiencyString = new BeefGuiLabel(this, "", leftX + 22, topY + 4);
        this.statusString = new BeefGuiLabel(this, "", leftX, topY += this.rotorEfficiencyIcon.getHeight() + 4);
        topY += this.statusString.getHeight() + 4;
        this.powerIcon = new BeefGuiIcon(this, this.field_74198_m + 153, this.field_74197_n + 4, 16, 16, ClientProxy.GuiIcons.getIcon("energyStored"), new String[]{"\u00a7bEnergy Storage"});
        this.powerBar = new BeefGuiPowerBar(this, this.field_74198_m + 152, this.field_74197_n + 22, this.turbine);
        this.steamIcon = new BeefGuiIcon(this, this.field_74198_m + 113, this.field_74197_n + 4, 16, 16, ClientProxy.GuiIcons.getIcon("hotFluidIn"), new String[]{"\u00a7bIntake Fluid Tank"});
        this.steamBar = new BeefGuiFluidBar((BeefGuiBase)this, this.field_74198_m + 112, this.field_74197_n + 22, this.turbine, 0);
        this.waterIcon = new BeefGuiIcon(this, this.field_74198_m + 133, this.field_74197_n + 4, 16, 16, ClientProxy.GuiIcons.getIcon("coolantOut"), new String[]{"\u00a7bExhaust Fluid Tank"});
        this.waterBar = new BeefGuiFluidBar((BeefGuiBase)this, this.field_74198_m + 132, this.field_74197_n + 22, this.turbine, 1);
        this.rpmIcon = new BeefGuiIcon(this, this.field_74198_m + 93, this.field_74197_n + 4, 16, 16, ClientProxy.GuiIcons.getIcon("rpm"), new String[]{"\u00a7bRotor Speed"});
        this.rpmBar = new BeefGuiRpmBar(this, this.field_74198_m + 92, this.field_74197_n + 22, this.turbine, "Rotor Speed", new String[]{"Rotors perform best at", "900 or 1800 RPM.", "", "Rotors kept overspeed for too", "long may fail.", "", "Catastrophically."});
        this.governorString = new BeefGuiLabel(this, "", this.field_74198_m + 4, this.field_74197_n + 110);
        this.btnGovernorUp = new GuiIconButton(2, this.field_74198_m + 110, this.field_74197_n + 104, 18, 18, ClientProxy.GuiIcons.getIcon("upArrow"), new String[]{"\u00a7bIncrease Max Flow Rate", "", "Higher flow rates will increase", "rotor speed.", "", "SHIFT: +10 mB", "CTRL: +100mB", "CTRL+SHIFT: +1000mB"});
        this.btnGovernorDown = new GuiIconButton(3, this.field_74198_m + 128, this.field_74197_n + 104, 18, 18, ClientProxy.GuiIcons.getIcon("downArrow"), new String[]{"\u00a7bDecrease Max Flow Rate", "", "Lower flow rates will decrease", "rotor speed.", "", "SHIFT: -10 mB", "CTRL: -100mB", "CTRL+SHIFT: -1000mB"});
        this.btnActivate = new GuiIconButton(0, this.field_74198_m + 4, this.field_74197_n + 144, 18, 18, ClientProxy.GuiIcons.getIcon("On_off"), new String[]{"\u00a7bActivate Turbine", "", "Enables flow of intake fluid to rotor.", "Fluid flow will spin up the rotor."});
        this.btnDeactivate = new GuiIconButton(1, this.field_74198_m + 24, this.field_74197_n + 144, 18, 18, ClientProxy.GuiIcons.getIcon("Off_off"), new String[]{"\u00a7bDeactivate Turbine", "", "Disables flow of intake fluid to rotor.", "The rotor will spin down."});
        this.btnVentAll = new GuiIconButton(4, this.field_74198_m + 4, this.field_74197_n + 124, 18, 18, ClientProxy.GuiIcons.getIcon("ventAllOff"), new String[]{"\u00a7bVent: All Exhaust", "", "Dump all exhaust fluids.", "The exhaust fluid tank", "will not fill."});
        this.btnVentOverflow = new GuiIconButton(5, this.field_74198_m + 24, this.field_74197_n + 124, 18, 18, ClientProxy.GuiIcons.getIcon("ventOverflowOff"), new String[]{"\u00a7bVent: Overflow Only", "", "Dump excess exhaust fluids.", "Excess fluids will be lost", "if exhaust fluid tank is full."});
        this.btnVentNone = new GuiIconButton(6, this.field_74198_m + 44, this.field_74197_n + 124, 18, 18, ClientProxy.GuiIcons.getIcon("ventNoneOff"), new String[]{"\u00a7bVent: Closed", "", "Preserve all exhaust fluids.", "Turbine will slow or halt", "fluid intake if exhaust", "fluid tank is full."});
        this.registerControl(this.titleString);
        this.registerControl(this.statusString);
        this.registerControl(this.speedIcon);
        this.registerControl(this.speedString);
        this.registerControl(this.energyGeneratedIcon);
        this.registerControl(this.energyGeneratedString);
        this.registerControl(this.rotorEfficiencyIcon);
        this.registerControl(this.rotorEfficiencyString);
        this.registerControl(this.powerBar);
        this.registerControl(this.steamBar);
        this.registerControl(this.waterBar);
        this.registerControl(this.powerIcon);
        this.registerControl(this.steamIcon);
        this.registerControl(this.waterIcon);
        this.registerControl(this.rpmIcon);
        this.registerControl(this.rpmBar);
        this.registerControl(this.governorString);
        this.registerControl(this.btnGovernorUp);
        this.registerControl(this.btnGovernorDown);
        this.registerControl(this.btnActivate);
        this.registerControl(this.btnDeactivate);
        this.registerControl(this.btnVentAll);
        this.registerControl(this.btnVentOverflow);
        this.registerControl(this.btnVentNone);
        this.updateStrings();
        this.updateTooltips();
    }

    private void updateStrings() {
        if (this.turbine.isActive()) {
            this.statusString.setLabelText("Status: \u00a72Active");
            this.btnActivate.setIcon(ClientProxy.GuiIcons.getIcon(10));
            this.btnDeactivate.setIcon(ClientProxy.GuiIcons.getIcon(7));
        } else {
            this.statusString.setLabelText("Status: \u00a74Inactive");
            this.btnActivate.setIcon(ClientProxy.GuiIcons.getIcon(9));
            this.btnDeactivate.setIcon(ClientProxy.GuiIcons.getIcon(8));
        }
        this.speedString.setLabelText(String.format("%.1f RPM", Float.valueOf(this.turbine.getRotorSpeed())));
        this.energyGeneratedString.setLabelText(String.format("%.0f RF/t", Float.valueOf(this.turbine.getEnergyGeneratedLastTick())));
        this.governorString.setLabelText(String.format("Max Flow: %d mB/t", this.turbine.getMaxIntakeRate()));
        if (this.turbine.isActive()) {
            if (this.turbine.getRotorEfficiencyLastTick() < 1.0f) {
                this.rotorEfficiencyString.setLabelText(String.format("%.1f%%", Float.valueOf(this.turbine.getRotorEfficiencyLastTick() * 100.0f)));
            } else {
                this.rotorEfficiencyString.setLabelText("100%");
            }
            int numBlades = this.turbine.getNumRotorBlades();
            int fluidLastTick = this.turbine.getFluidConsumedLastTick();
            int neededBlades = fluidLastTick / 25;
            this.rotorEfficiencyString.setLabelTooltip(String.format("%d / %d blades", numBlades, neededBlades));
        } else {
            this.rotorEfficiencyString.setLabelText("Unknown");
        }
        switch (this.turbine.getVentSetting()) {
            case DoNotVent: {
                this.btnVentNone.setIcon(ClientProxy.GuiIcons.getIcon(32));
                this.btnVentOverflow.setIcon(ClientProxy.GuiIcons.getIcon(29));
                this.btnVentAll.setIcon(ClientProxy.GuiIcons.getIcon(27));
                break;
            }
            case VentOverflow: {
                this.btnVentNone.setIcon(ClientProxy.GuiIcons.getIcon(31));
                this.btnVentOverflow.setIcon(ClientProxy.GuiIcons.getIcon(30));
                this.btnVentAll.setIcon(ClientProxy.GuiIcons.getIcon(27));
                break;
            }
            default: {
                this.btnVentNone.setIcon(ClientProxy.GuiIcons.getIcon(31));
                this.btnVentOverflow.setIcon(ClientProxy.GuiIcons.getIcon(29));
                this.btnVentAll.setIcon(ClientProxy.GuiIcons.getIcon(28));
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateStrings();
    }

    protected void updateTooltips() {
    }

    protected void func_73875_a(GuiButton button) {
        CoordTriplet saveDelegate = this.turbine.getReferenceCoord();
        if (button.field_73741_f == 0 || button.field_73741_f == 1) {
            boolean setActive;
            boolean bl = setActive = button.field_73741_f == 0;
            if (setActive != this.turbine.isActive()) {
                PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket("BigReactors", 0, new Object[]{saveDelegate.x, saveDelegate.y, saveDelegate.z, setActive}));
            }
        }
        if (button.field_73741_f == 2 || button.field_73741_f == 3) {
            int exponent = 0;
            if (GuiTurbineController.func_73877_p()) {
                ++exponent;
            }
            if (GuiTurbineController.func_73861_o()) {
                exponent += 2;
            }
            int newMax = (int)Math.round(Math.pow(10.0, exponent));
            if (button.field_73741_f == 3) {
                newMax *= -1;
            }
            if ((newMax = Math.max(0, Math.min(this.turbine.getMaxIntakeRateMax(), this.turbine.getMaxIntakeRate() + newMax))) != this.turbine.getMaxIntakeRate()) {
                PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket("BigReactors", 15, new Object[]{saveDelegate.x, saveDelegate.y, saveDelegate.z, newMax}));
            }
        }
        if (button.field_73741_f >= 4 && button.field_73741_f <= 6) {
            MultiblockTurbine.VentStatus newStatus;
            switch (button.field_73741_f) {
                case 5: {
                    newStatus = MultiblockTurbine.VentStatus.VentOverflow;
                    break;
                }
                case 6: {
                    newStatus = MultiblockTurbine.VentStatus.DoNotVent;
                    break;
                }
                default: {
                    newStatus = MultiblockTurbine.VentStatus.VentAll;
                }
            }
            if (newStatus != this.turbine.getVentSetting()) {
                PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket("BigReactors", 16, new Object[]{saveDelegate.x, saveDelegate.y, saveDelegate.z, newStatus.ordinal()}));
            }
        }
    }
}

