/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;
import tmechworks.TMechworks;

public class FirestarterLogic
extends TileEntity
implements IFacingLogic,
IActiveLogic {
    boolean active;
    boolean shouldActivate;
    byte direction;

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.shouldActivate = true;
    }

    void setFire() {
        int xPos = this.field_70329_l;
        int yPos = this.field_70330_m;
        int zPos = this.field_70327_n;
        switch (this.direction) {
            case 0: {
                --yPos;
                break;
            }
            case 1: {
                ++yPos;
                break;
            }
            case 2: {
                --zPos;
                break;
            }
            case 3: {
                ++zPos;
                break;
            }
            case 4: {
                --xPos;
                break;
            }
            case 5: {
                ++xPos;
            }
        }
        Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, yPos, zPos)];
        if (this.active) {
            TMechworks.logger.info("Setting fire");
            if (block == null || block.isAirBlock(this.field_70331_k, xPos, yPos, zPos)) {
                this.field_70331_k.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "fire.ignite", 1.0f, AbilityHelper.random.nextFloat() * 0.4f + 0.8f);
                this.field_70331_k.func_94575_c(xPos, yPos, zPos, Block.field_72067_ar.field_71990_ca);
            }
        } else if (block == Block.field_72067_ar) {
            this.field_70331_k.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "fire.ignite", 1.0f, AbilityHelper.random.nextFloat() * 0.4f + 0.8f);
            this.field_70331_k.func_72832_d(xPos, yPos, zPos, 0, 0, 3);
            this.shouldActivate = true;
        }
    }

    public void func_70316_g() {
        if (this.shouldActivate) {
            this.shouldActivate = false;
            this.setFire();
        }
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        tags.func_74757_a("Active", this.active);
        this.readCustomNBT(tags);
    }

    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.active = tags.func_74767_n("Active");
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

