/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;
import tmechworks.inventory.AdvancedDrawbridgeContainer;
import tmechworks.lib.blocks.IDrawbridgeLogicBase;
import tmechworks.lib.blocks.InventoryLogic;
import tmechworks.lib.player.FakePlayerLogic;

public class AdvancedDrawbridgeLogic
extends InventoryLogic
implements IFacingLogic,
IActiveLogic,
IDrawbridgeLogicBase {
    boolean active;
    boolean working;
    int ticks;
    public int selSlot = 0;
    byte extension;
    byte direction;
    byte placementDirection = (byte)4;
    FakePlayerLogic fakePlayer;
    ItemStack[] bufferStacks = new ItemStack[this.func_70302_i_()];
    public InvCamo camoInventory = new InvCamo();

    public AdvancedDrawbridgeLogic() {
        super(16);
    }

    public void func_70308_a(World par1World) {
        this.field_70331_k = par1World;
    }

    private void initFakePlayer() {
        if (this.fakePlayer == null && !this.func_70320_p()) {
            this.fakePlayer = new FakePlayerLogic("Player.Drawbridge", this);
        }
    }

    public void func_70312_q() {
        this.field_70328_o = false;
        this.fakePlayer = new FakePlayerLogic("Player.Drawbridge", this);
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.working = true;
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    @Override
    public boolean canDropInventorySlot(int slot) {
        return false;
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public void setPlacementDirection(byte keycode) {
        if (!this.field_70331_k.field_72995_K) {
            this.initFakePlayer();
            if (keycode == 4) {
                this.fakePlayer.field_70177_z = 0.0f;
                this.fakePlayer.field_70125_A = 0.0f;
            } else if (this.direction == 0 || this.direction == 1) {
                switch (keycode) {
                    case 0: {
                        this.fakePlayer.field_70177_z = 0.0f;
                        break;
                    }
                    case 1: {
                        this.fakePlayer.field_70177_z = 90.0f;
                        break;
                    }
                    case 2: {
                        this.fakePlayer.field_70177_z = 180.0f;
                        break;
                    }
                    case 3: {
                        this.fakePlayer.field_70177_z = 270.0f;
                    }
                }
                this.fakePlayer.field_70125_A = this.direction == 0 ? -90.0f : 90.0f;
            } else if (keycode == 0) {
                this.fakePlayer.field_70177_z = this.mapDirection() * 90;
                this.fakePlayer.field_70125_A = keycode == 0 ? 90.0f : -90.0f;
            } else if (keycode == 2) {
                int face = this.mapDirection() + 2;
                if (face > 3) {
                    face -= 4;
                }
                this.fakePlayer.field_70177_z = face * 90;
                this.fakePlayer.field_70125_A = keycode == 0 ? 90.0f : -90.0f;
            } else {
                this.fakePlayer.field_70125_A = 0.0f;
                int facing = this.mapDirection();
                facing = keycode == 1 ? ++facing : --facing;
                if (facing >= 4) {
                    facing = 0;
                }
                if (facing < 0) {
                    facing = 3;
                }
                this.fakePlayer.field_70177_z = facing * 90;
            }
        }
        this.placementDirection = keycode;
    }

    int mapDirection() {
        if (this.direction == 2) {
            return 0;
        }
        if (this.direction == 5) {
            return 1;
        }
        if (this.direction == 3) {
            return 2;
        }
        return 3;
    }

    @Override
    public byte getPlacementDirection() {
        return this.placementDirection;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return slot < this.inventory.length ? this.inventory[slot] : null;
    }

    public ItemStack getStackInBufferSlot(int slot) {
        return slot < this.bufferStacks.length ? this.bufferStacks[slot] : null;
    }

    public void setBufferSlotContents(int slot, ItemStack itemstack) {
        if (slot >= this.bufferStacks.length) {
            return;
        }
        this.bufferStacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new AdvancedDrawbridgeContainer(inventoryplayer, this);
    }

    @Override
    protected String getDefaultName() {
        return "tinker.drawbridge";
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        if (slot == 1) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return stack;
    }

    public void func_70316_g() {
        if (this.working && !this.func_70320_p()) {
            ++this.ticks;
            if (this.ticks == 5) {
                this.ticks = 0;
                if (this.active) {
                    if (this.func_70301_a(this.extension) != null && this.func_70301_a((int)this.extension).field_77994_a > 0 && this.extension < 15) {
                        this.extension = (byte)(this.extension + 1);
                        int xPos = this.field_70329_l;
                        int yPos = this.field_70330_m;
                        int zPos = this.field_70327_n;
                        switch (this.direction) {
                            case 0: {
                                yPos -= this.extension;
                                break;
                            }
                            case 1: {
                                yPos += this.extension;
                                break;
                            }
                            case 2: {
                                zPos -= this.extension;
                                break;
                            }
                            case 3: {
                                zPos += this.extension;
                                break;
                            }
                            case 4: {
                                xPos -= this.extension;
                                break;
                            }
                            case 5: {
                                xPos += this.extension;
                            }
                        }
                        Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, yPos, zPos)];
                        if (block == null || block.isAirBlock(this.field_70331_k, xPos, yPos, zPos) || block.isBlockReplaceable(this.field_70331_k, xPos, yPos, zPos)) {
                            List list;
                            AxisAlignedBB axisalignedbb;
                            int blockToItem;
                            this.initFakePlayer();
                            int n = blockToItem = this.getStackInBufferSlot(this.extension - 1) != null ? TConstructRegistry.blockToItemMapping[this.getStackInBufferSlot((int)(this.extension - 1)).field_77993_c] : 0;
                            if (blockToItem == 0) {
                                if (this.func_70301_a(this.extension - 1) == null || this.func_70301_a((int)(this.extension - 1)).field_77993_c >= 4096 || Block.field_71973_m[this.func_70301_a((int)(this.extension - 1)).field_77993_c] == null) {
                                    return;
                                }
                                ItemStack placeStack = this.getStackInBufferSlot(this.extension - 1);
                                if (placeStack != null) {
                                    Block placeBlock = Block.field_71973_m[placeStack.field_77993_c];
                                    this.placeBlockAt(this.func_70301_a(this.extension - 1), (EntityPlayer)this.fakePlayer, this.field_70331_k, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.func_70301_a(this.extension - 1).func_77960_j(), placeBlock);
                                }
                            } else {
                                Block placeBlock = Block.field_71973_m[blockToItem];
                                this.placeBlockAt(this.func_70301_a(this.extension - 1), (EntityPlayer)this.fakePlayer, this.field_70331_k, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.func_70301_a(this.extension - 1).func_77960_j(), placeBlock);
                            }
                            this.field_70331_k.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.out", 0.25f, this.field_70331_k.field_73012_v.nextFloat() * 0.25f + 0.6f);
                            ArrayList pushedObjects = new ArrayList();
                            Block axis = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, yPos, zPos)];
                            AxisAlignedBB axisAlignedBB = axisalignedbb = axis != null ? axis.func_71872_e(this.field_70331_k, xPos, yPos, zPos) : null;
                            if (axisalignedbb != null && !(list = this.field_70331_k.func_72839_b((Entity)null, axisalignedbb)).isEmpty()) {
                                pushedObjects.addAll(list);
                                for (Entity entity : pushedObjects) {
                                    entity.func_70091_d((double)Facing.field_71586_b[this.direction], (double)Facing.field_71587_c[this.direction], (double)Facing.field_71585_d[this.direction]);
                                }
                                pushedObjects.clear();
                            }
                            this.func_70298_a(this.extension - 1, 1);
                        } else {
                            this.extension = (byte)(this.extension - 1);
                            this.working = false;
                        }
                    } else {
                        this.working = false;
                    }
                } else if ((this.func_70301_a(this.extension) == null || this.func_70301_a((int)this.extension).field_77994_a < this.func_70301_a(this.extension).func_77976_d()) && this.extension > 0) {
                    int xPos = this.field_70329_l;
                    int yPos = this.field_70330_m;
                    int zPos = this.field_70327_n;
                    switch (this.direction) {
                        case 0: {
                            yPos -= this.extension;
                            break;
                        }
                        case 1: {
                            yPos += this.extension;
                            break;
                        }
                        case 2: {
                            zPos -= this.extension;
                            break;
                        }
                        case 3: {
                            zPos += this.extension;
                            break;
                        }
                        case 4: {
                            xPos -= this.extension;
                            break;
                        }
                        case 5: {
                            xPos += this.extension;
                        }
                    }
                    Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, yPos, zPos)];
                    if (block != null) {
                        int meta = this.field_70331_k.func_72805_g(xPos, yPos, zPos);
                        if (this.getStackInBufferSlot(this.extension - 1) != null && this.validBlock(this.extension - 1, block) && this.validMetadata(this.extension - 1, block, meta) && this.validDrawbridge(xPos, yPos, zPos)) {
                            this.field_70331_k.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.in", 0.25f, this.field_70331_k.field_73012_v.nextFloat() * 0.15f + 0.6f);
                            if (this.field_70331_k.func_94575_c(xPos, yPos, zPos, 0)) {
                                if (this.func_70301_a(this.extension - 1) == null) {
                                    this.func_70299_a(this.extension - 1, this.getStackInBufferSlot(this.extension - 1).func_77946_l());
                                } else {
                                    ++this.func_70301_a((int)(this.extension - 1)).field_77994_a;
                                }
                            }
                        } else {
                            this.working = false;
                        }
                    }
                    this.extension = (byte)(this.extension - 1);
                } else {
                    this.working = false;
                }
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata, Block block) {
        if (!world.func_72832_d(x, y, z, block.field_71990_ca, metadata, 3)) {
            return false;
        }
        if (world.func_72798_a(x, y, z) == block.field_71990_ca) {
            block.func_71860_a(world, x, y, z, (EntityLivingBase)player, stack);
            block.func_85105_g(world, x, y, z, metadata);
        }
        return true;
    }

    boolean validDrawbridge(int x, int y, int z) {
        TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
        return !(te instanceof IDrawbridgeLogicBase) || !((IDrawbridgeLogicBase)te).hasExtended();
    }

    boolean validBlock(int slot, Block block) {
        int type = TConstructRegistry.interchangableBlockMapping[block.field_71990_ca];
        if (type != 0 && type == this.getStackInBufferSlot((int)slot).field_77993_c) {
            return true;
        }
        int blockToItem = TConstructRegistry.blockToItemMapping[block.field_71990_ca];
        if (blockToItem != 0 && blockToItem == this.getStackInBufferSlot((int)slot).field_77993_c) {
            return true;
        }
        return block.field_71990_ca == this.getStackInBufferSlot((int)slot).field_77993_c;
    }

    boolean validMetadata(int slot, Block block, int metadata) {
        int type = TConstructRegistry.drawbridgeState[block.field_71990_ca];
        if (type == 0) {
            return metadata == this.getStackInBufferSlot(slot).func_77960_j();
        }
        if (type == 1) {
            return true;
        }
        if (type == 2) {
            return false;
        }
        if (type == 3) {
            return true;
        }
        if (type == 4) {
            return true;
        }
        if (type == 5) {
            return metadata == this.getStackInBufferSlot(slot).func_77960_j();
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.active = tags.func_74767_n("Active");
        this.working = tags.func_74767_n("Working");
        this.extension = tags.func_74771_c("Extension");
        NBTTagCompound camoTag = (NBTTagCompound)tags.func_74781_a("Camo");
        if (camoTag != null) {
            this.camoInventory.func_70299_a(0, ItemStack.func_77949_a((NBTTagCompound)camoTag));
        }
        this.readBufferFromNBT(tags);
        this.readCustomNBT(tags);
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74757_a("Active", this.active);
        tags.func_74757_a("Working", this.working);
        tags.func_74774_a("Extension", this.extension);
        if (this.camoInventory.func_70301_a(0) != null) {
            NBTTagCompound camoTag = new NBTTagCompound();
            this.camoInventory.func_70301_a(0).func_77955_b(camoTag);
            tags.func_74782_a("Camo", (NBTBase)camoTag);
        }
        this.writeBufferToNBT(tags);
        this.writeCustomNBT(tags);
    }

    public void readBufferFromNBT(NBTTagCompound tags) {
        NBTTagList nbttaglist = tags.func_74761_m("Buffer");
        this.bufferStacks = new ItemStack[this.func_70302_i_()];
        for (int iter = 0; iter < nbttaglist.func_74745_c(); ++iter) {
            NBTTagCompound tagList = (NBTTagCompound)nbttaglist.func_74743_b(iter);
            byte slotID = tagList.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.bufferStacks.length) continue;
            this.setBufferSlotContents(slotID, ItemStack.func_77949_a((NBTTagCompound)tagList));
        }
    }

    public void writeBufferToNBT(NBTTagCompound tags) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int iter = 0; iter < this.bufferStacks.length; ++iter) {
            if (this.getStackInBufferSlot(iter) == null) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74774_a("Slot", (byte)iter);
            this.getStackInBufferSlot(iter).func_77955_b(tagList);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        tags.func_74782_a("Buffer", (NBTBase)nbttaglist);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
        this.placementDirection = tags.func_74771_c("Placement");
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
        tags.func_74774_a("Placement", this.placementDirection);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean hasExtended() {
        return this.extension != 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            this.setBufferSlotContents(i, this.func_70301_a(i).func_77946_l());
            this.getStackInBufferSlot((int)i).field_77994_a = 1;
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public class InvCamo
    extends InventoryBasic {
        private InvCamo() {
            super("camoSlot", false, 1);
        }

        public ItemStack getCamoStack() {
            return this.func_70301_a(0);
        }

        public void func_70299_a(int slot, ItemStack content) {
            super.func_70299_a(slot, content);
            if (slot == 0 && AdvancedDrawbridgeLogic.this.field_70331_k != null) {
                AdvancedDrawbridgeLogic.this.field_70331_k.func_72845_h(AdvancedDrawbridgeLogic.this.field_70329_l, AdvancedDrawbridgeLogic.this.field_70330_m, AdvancedDrawbridgeLogic.this.field_70327_n);
            }
        }

        public void func_70296_d() {
            super.func_70296_d();
            if (AdvancedDrawbridgeLogic.this.field_70331_k != null) {
                AdvancedDrawbridgeLogic.this.field_70331_k.func_72845_h(AdvancedDrawbridgeLogic.this.field_70329_l, AdvancedDrawbridgeLogic.this.field_70330_m, AdvancedDrawbridgeLogic.this.field_70327_n);
            }
        }

        public int func_70297_j_() {
            return 1;
        }
    }
}

