/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.script.statements;

import java.util.Iterator;
import stanhebben.minetweaker.api.TweakerException;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.script.TweakerFile;
import stanhebben.minetweaker.script.expressions.TweakerExpression;
import stanhebben.minetweaker.script.statements.TweakerStatement;

public class StatementForeach
extends TweakerStatement {
    private final String varname;
    private final TweakerExpression list;
    private final TweakerStatement body;

    public StatementForeach(TweakerFile file, int line, int offset, String varname, TweakerExpression list, TweakerStatement body) {
        super(file, line, offset);
        this.varname = varname;
        this.list = list;
        this.body = body;
    }

    @Override
    public TweakerValue execute(TweakerNameSpace namespace) throws TweakerException {
        TweakerValue listValue = this.list.execute(namespace);
        namespace = new TweakerNameSpace(namespace);
        try {
            Iterator<TweakerValue> values = listValue.iterator();
            if (values == null) {
                throw new TweakerExecuteException("This value is not iterable");
            }
            while (values.hasNext()) {
                namespace.put(this.varname, values.next());
                TweakerValue result = this.body.execute(namespace);
                if (result == null) continue;
                return result;
            }
        }
        catch (TweakerExecuteException ex) {
            throw new TweakerException(this.getFile(), this.getLine(), this.getOffset(), ex.getMessage());
        }
        return null;
    }
}

