/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryRanchable;
import powercrystals.minefactoryreloaded.api.RanchedItem;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerItemStack;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;
import stanhebben.minetweaker.mods.mfr.MFRHacks;

public class RancherAddRanchableAction
implements IUndoableAction {
    private static final Random random = new Random();
    private final Class<?> clazz;
    private final TweakerItemStack[] items;
    private final float[] itemChances;
    private final TweakerLiquidStack[] liquids;
    private final float[] liquidChances;
    private final TweakerItem[] validContainers;
    private final IFactoryRanchable old;

    public RancherAddRanchableAction(Class<?> clazz, TweakerItemStack[] items, float[] itemChances, TweakerLiquidStack[] liquids, float[] liquidChances, TweakerItem[] validContainers) {
        this.clazz = clazz;
        this.items = items;
        this.itemChances = itemChances;
        this.liquids = liquids;
        this.liquidChances = liquidChances;
        this.validContainers = validContainers;
        this.old = MFRHacks.ranchables == null ? null : MFRHacks.ranchables.get(clazz);
    }

    @Override
    public void apply() {
        FactoryRegistry.registerRanchable((IFactoryRanchable)new SimpleRanchable(this.clazz, this.items, this.itemChances, this.liquids, this.liquidChances, this.validContainers));
    }

    @Override
    public boolean canUndo() {
        return MFRHacks.ranchables != null;
    }

    @Override
    public void undo() {
        if (this.old == null) {
            MFRHacks.ranchables.remove(this.clazz);
        } else {
            FactoryRegistry.registerRanchable((IFactoryRanchable)this.old);
        }
    }

    @Override
    public String describe() {
        return "Adding ranchable " + this.clazz.getCanonicalName();
    }

    @Override
    public String describeUndo() {
        if (this.old == null) {
            return "Removing ranchable " + this.clazz.getCanonicalName();
        }
        return "Restoring ranchable " + this.clazz.getCanonicalName();
    }

    private static class SimpleRanchable
    implements IFactoryRanchable {
        private final Class<?> clazz;
        private final TweakerItemStack[] items;
        private final float[] itemChances;
        private final TweakerLiquidStack[] liquids;
        private final float[] liquidChances;
        private final TweakerItem[] validContainers;

        public SimpleRanchable(Class<?> clazz, TweakerItemStack[] items, float[] itemChances, TweakerLiquidStack[] liquids, float[] liquidChances, TweakerItem[] validContainers) {
            this.clazz = clazz;
            this.items = items;
            this.itemChances = itemChances;
            this.liquids = liquids;
            this.liquidChances = liquidChances;
            this.validContainers = validContainers;
        }

        public Class<?> getRanchableEntity() {
            return this.clazz;
        }

        public List<RanchedItem> ranch(abw world, of entity, mo rancher) {
            ArrayList<RanchedItem> result = new ArrayList<RanchedItem>();
            if (this.clazz.isAssignableFrom(entity.getClass())) {
                int i;
                for (i = 0; i < this.items.length; ++i) {
                    if (!(random.nextFloat() <= this.itemChances[i])) continue;
                    result.add(new RanchedItem(this.items[i].get()));
                }
                for (i = 0; i < this.liquids.length; ++i) {
                    if (!(random.nextFloat() <= this.liquidChances[i])) continue;
                    this.liquids[i].fill(rancher, this.validContainers);
                }
            }
            return result;
        }
    }
}

