/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.mods.mfr.MFRHacks;

public class FruitPickerAddFruitAction
implements IUndoableAction {
    private final TweakerItem item;
    private final IFactoryFruit fruit;
    private final IFactoryFruit old;

    public FruitPickerAddFruitAction(TweakerItem item, IFactoryFruit fruit) {
        this.item = item;
        this.fruit = fruit;
        this.old = MFRHacks.fruitBlocks == null ? null : MFRHacks.fruitBlocks.get(item.getItemId());
    }

    @Override
    public void apply() {
        FactoryRegistry.registerFruit((IFactoryFruit)this.fruit);
    }

    @Override
    public boolean canUndo() {
        return MFRHacks.fruitBlocks != null;
    }

    @Override
    public void undo() {
        if (this.old == null) {
            MFRHacks.fruitBlocks.remove(this.item.getItemId());
        } else {
            FactoryRegistry.registerFruit((IFactoryFruit)this.old);
        }
    }

    @Override
    public String describe() {
        return "Adding fruit " + this.item.getDisplayName();
    }

    @Override
    public String describeUndo() {
        if (this.old == null) {
            return "Removing fruit " + this.item.getDisplayName();
        }
        return "Restoring fruit " + this.item.getDisplayName();
    }
}

