/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.mods.mfr.MFRHacks;

public class FertilizerAddFertilizerAction
implements IUndoableAction {
    private final TweakerItem item;
    private final FertilizerType type;
    private final IFactoryFertilizer old;

    public FertilizerAddFertilizerAction(TweakerItem item, FertilizerType type) {
        this.item = item;
        this.type = type;
        this.old = MFRHacks.fertilizers == null ? null : MFRHacks.fertilizers.get(item.getItemId());
    }

    @Override
    public void apply() {
        FactoryRegistry.registerFertilizer((IFactoryFertilizer)new SimpleFertilizer(this.item, this.type));
    }

    @Override
    public boolean canUndo() {
        return MFRHacks.fertilizers != null;
    }

    @Override
    public void undo() {
        if (this.old == null) {
            MFRHacks.fertilizers.remove(this.item.getItemId());
        } else {
            FactoryRegistry.registerFertilizer((IFactoryFertilizer)this.old);
        }
    }

    @Override
    public String describe() {
        return "Adding fertilizer " + this.item.getDisplayName();
    }

    @Override
    public String describeUndo() {
        if (this.old == null) {
            return "Removing fertilizer " + this.item.getDisplayName();
        }
        return "Restoring fertilizer " + this.item.getDisplayName();
    }

    private static class SimpleFertilizer
    implements IFactoryFertilizer {
        private final TweakerItem item;
        private final FertilizerType type;

        public SimpleFertilizer(TweakerItem item, FertilizerType type) {
            this.item = item;
            this.type = type;
        }

        public int getFertilizerId() {
            return this.item.getItemId();
        }

        public int getFertilizerMeta() {
            return this.item.getItemSubId();
        }

        public FertilizerType getFertilizerType() {
            return this.type;
        }

        public void consume(ye fertilizer) {
            --fertilizer.b;
        }
    }
}

