/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.functions;

import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.mods.forestry.actions.GeneratorAddFuelAction;

public class GeneratorAddFuelFunction
extends TweakerFunction {
    public static final GeneratorAddFuelFunction INSTANCE = new GeneratorAddFuelFunction();

    private GeneratorAddFuelFunction() {
    }

    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        if (arguments.length != 3) {
            throw new TweakerExecuteException("bioGenerator.addFuel requires 3 arguments");
        }
        TweakerLiquidStack fluidConsumed = GeneratorAddFuelFunction.notNull(arguments[0], "fuel cannot be null").toFluidStack("fuel must be a liquid stack");
        int euPerTick = GeneratorAddFuelFunction.notNull(arguments[1], "eu per tick cannot be null").toInt("eu per tick must be an int").get();
        int ticksPerMillibucket = GeneratorAddFuelFunction.notNull(arguments[2], "ticks per millibucket cannot be null").toInt("ticks per millibucket must be an int").get();
        Tweaker.apply(new GeneratorAddFuelAction(fluidConsumed, euPerTick, ticksPerMillibucket));
        return null;
    }

    @Override
    public String toString() {
        return "bioGenerator.addFuel";
    }
}

