/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import java.util.logging.Level;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;

public class MoistenerRemoveFuelAction
implements IUndoableAction {
    private final ye item;
    private boolean asItem;
    private MoistenerFuel fuel;

    public MoistenerRemoveFuelAction(ye item) {
        this.item = item;
    }

    @Override
    public void apply() {
        if (FuelManager.moistenerResource.containsKey(this.item)) {
            this.asItem = false;
            this.fuel = (MoistenerFuel)FuelManager.moistenerResource.remove(this.item);
        } else if (FuelManager.moistenerResource.containsKey(this.item.b())) {
            this.asItem = true;
            this.fuel = (MoistenerFuel)FuelManager.moistenerResource.remove(this.item.b());
        } else {
            Tweaker.log(Level.WARNING, "Could not find moistener fuel " + this.item.s());
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.fuel != null) {
            if (this.asItem) {
                FuelManager.moistenerResource.put(this.item.b(), this.fuel);
            } else {
                FuelManager.moistenerResource.put(this.item, this.fuel);
            }
        }
    }

    @Override
    public String describe() {
        return "Removing moistener fuel " + this.item.s();
    }

    @Override
    public String describeUndo() {
        return "Restoring moistener fuel " + this.item.s();
    }
}

