/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;

public class MoistenerAddFuelAction
implements IUndoableAction {
    private final TweakerItem input;
    private final TweakerItem output;
    private final int value;
    private final int stage;

    public MoistenerAddFuelAction(TweakerItem output, TweakerItem input, int value, int stage) {
        this.input = input;
        this.output = output;
        this.value = value;
        this.stage = stage;
    }

    @Override
    public void apply() {
        FuelManager.moistenerResource.put(this.input.make(1), new MoistenerFuel(this.input.make(1), this.output.make(1), this.value, this.stage));
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        FuelManager.moistenerResource.remove(this.input.make(1));
    }

    @Override
    public String describe() {
        return "Adding moistener resource " + this.input.getDisplayName();
    }

    @Override
    public String describeUndo() {
        return "Removing moistener resource " + this.input.getDisplayName();
    }
}

