/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.functions;

import buildcraft.api.recipes.RefineryRecipes;
import java.util.ArrayList;
import java.util.logging.Level;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.mods.buildcraft.BuildCraftUtil;
import stanhebben.minetweaker.mods.buildcraft.actions.RefineryRemoveRecipeAction;
import stanhebben.minetweaker.mods.buildcraft.functions.RefineryRemoveFunction;

public class RefineryRemoveRecipeFunction
extends TweakerFunction {
    public static final RefineryRemoveRecipeFunction INSTANCE = new RefineryRemoveRecipeFunction();

    private RefineryRemoveRecipeFunction() {
    }

    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        if (arguments.length == 0) {
            throw new TweakerExecuteException("refinery.removeRecipe requires at least one argument");
        }
        if (arguments.length == 1) {
            return RefineryRemoveFunction.INSTANCE.call(namespace, arguments);
        }
        TweakerLiquid output = RefineryRemoveRecipeFunction.notNull(arguments[0], "the refinery.removeRecipe output cannot be null").toFluid("the refinery.removeRecipe output must be a fluid");
        TweakerLiquid input1 = RefineryRemoveRecipeFunction.notNull(arguments[1], "the refinery.removeRecipe input cannot be null").toFluid("the refinery.removeRecipe input must be a fluid");
        TweakerLiquid input2 = null;
        if (arguments.length >= 3) {
            input2 = RefineryRemoveRecipeFunction.notNull(arguments[2], "the refinery.removeRecipe input2 cannot be null").toFluid("the refinery.removeRecipe input2 must be a fluid");
        }
        if (BuildCraftUtil.getRefineryRecipes() == null) {
            Tweaker.log(Level.WARNING, "Could not execute the refinery recipe removed due to reflection failing. Operation ignored.");
            return null;
        }
        ArrayList<RefineryRemoveRecipeAction> actions = new ArrayList<RefineryRemoveRecipeAction>();
        for (RefineryRecipes.Recipe recipe : BuildCraftUtil.getRefineryRecipes()) {
            if (!output.equalsFluid(recipe.result.getFluid()) || !input1.equalsFluid(recipe.ingredient1.getFluid()) || (input2 == null ? recipe.ingredient2 != null : !input2.equalsFluid(recipe.ingredient2.getFluid()))) continue;
            actions.add(new RefineryRemoveRecipeAction(recipe));
        }
        for (RefineryRemoveRecipeAction action : actions) {
            Tweaker.apply(action);
        }
        return null;
    }

    @Override
    public String toString() {
        return "buildcraft.refinery.removeRecipe";
    }
}

