/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.functions;

import buildcraft.api.recipes.RefineryRecipes;
import java.util.ArrayList;
import java.util.logging.Level;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.mods.buildcraft.BuildCraftUtil;
import stanhebben.minetweaker.mods.buildcraft.actions.RefineryRemoveRecipeAction;

public class RefineryRemoveFunction
extends TweakerFunction {
    public static final RefineryRemoveFunction INSTANCE = new RefineryRemoveFunction();

    private RefineryRemoveFunction() {
    }

    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        if (arguments.length == 0) {
            throw new TweakerExecuteException("refinery.removeRecipe requires at least one argument");
        }
        TweakerLiquid output = RefineryRemoveFunction.notNull(arguments[0], "the refinery.remove output cannot be null").toFluid("the refinery.remove output must be a fluid");
        if (BuildCraftUtil.getRefineryRecipes() == null) {
            Tweaker.log(Level.WARNING, "Could not execute the refinery recipe removed due to reflection failing. Operation ignored.");
            return null;
        }
        ArrayList<RefineryRemoveRecipeAction> actions = new ArrayList<RefineryRemoveRecipeAction>();
        for (RefineryRecipes.Recipe recipe : BuildCraftUtil.getRefineryRecipes()) {
            if (!output.equalsFluid(recipe.result.getFluid())) continue;
            actions.add(new RefineryRemoveRecipeAction(recipe));
        }
        for (RefineryRemoveRecipeAction action : actions) {
            Tweaker.apply(action);
        }
        return null;
    }

    @Override
    public String toString() {
        return "buildcraft.refinery.remove";
    }
}

