/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.functions;

import buildcraft.api.core.StackWrapper;
import buildcraft.api.fuels.IronEngineCoolant;
import java.util.logging.Level;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.mods.buildcraft.actions.AddLiquidCoolantAction;
import stanhebben.minetweaker.mods.buildcraft.actions.AddSolidCoolantAction;

public class AddCoolantFunction
extends TweakerFunction {
    public static final AddCoolantFunction INSTANCE = new AddCoolantFunction();

    private AddCoolantFunction() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        if (arguments.length < 2) {
            throw new TweakerExecuteException("coolants.add requires at least 2 arguments");
        }
        TweakerValue coolant = AddCoolantFunction.notNull(arguments[0], "coolants.add coolant cannot be null");
        if (coolant.asFluid() != null) {
            TweakerLiquid coolantFluid = coolant.asFluid();
            if (IronEngineCoolant.isCoolant((Fluid)coolantFluid.get())) {
                throw new TweakerExecuteException(coolantFluid.getName() + " is already a coolant");
            }
            float cooling = AddCoolantFunction.notNull(arguments[1], "coolants.add cooling value cannot be null").toFloat("coolants.add cooling value must be a float value").get();
            Tweaker.apply(new AddLiquidCoolantAction(coolantFluid.get(), cooling));
            return null;
        } else {
            if (coolant.asItem() == null) throw new TweakerExecuteException("coolants.add requires either a fluid or item");
            TweakerItem item = coolant.asItem();
            if (IronEngineCoolant.solidCoolants.containsKey(new StackWrapper(item.make(1)))) {
                throw new TweakerExecuteException(item.getDisplayName() + " is already a coolant");
            }
            if (FluidContainerRegistry.isContainer((ye)item.make(1))) {
                Tweaker.log(Level.INFO, item.getDisplayName() + " is already registered as fluid");
                return null;
            } else {
                TweakerLiquidStack cooling = AddCoolantFunction.notNull(arguments[1], "coolants.add cooling value must not be null").toFluidStack("coolants.add cooling value must be a fluid stack");
                if (!IronEngineCoolant.liquidCoolants.containsKey(cooling.get().getFluid().getName())) throw new TweakerExecuteException(cooling.get().getFluid().getLocalizedName() + " must be registered as coolant first");
                Tweaker.apply(new AddSolidCoolantAction(item.make(1), cooling.get()));
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "buildcraft.coolants.add";
    }
}

