/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.actions;

import buildcraft.api.core.BuildCraftAPI;
import stanhebben.minetweaker.api.IUndoableAction;

public class SetSoftBlockAction
implements IUndoableAction {
    private final int id;
    private final boolean newValue;
    private final boolean oldValue;

    public SetSoftBlockAction(int id, boolean newValue) {
        this.id = id;
        this.newValue = newValue;
        this.oldValue = BuildCraftAPI.softBlocks[id];
    }

    @Override
    public void apply() {
        BuildCraftAPI.softBlocks[this.id] = this.newValue;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        BuildCraftAPI.softBlocks[this.id] = this.oldValue;
    }

    @Override
    public String describe() {
        return "setting soft block status of " + aqz.s[this.id].A() + " to " + (this.newValue ? "soft" : "hard");
    }

    @Override
    public String describeUndo() {
        return "setting soft block status of " + aqz.s[this.id].A() + " to " + (this.oldValue ? "soft" : "hard");
    }
}

