/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.actions;

import buildcraft.api.fuels.IronEngineFuel;
import net.minecraftforge.fluids.Fluid;
import stanhebben.minetweaker.api.IUndoableAction;

public class SetFuelAction
implements IUndoableAction {
    private final Fluid fluid;
    private final float powerPerCycle;
    private final int numTotalCycles;
    private final IronEngineFuel.Fuel old;

    public SetFuelAction(Fluid fluid, float powerPerCycle, int numTotalCycles) {
        this.fluid = fluid;
        this.powerPerCycle = powerPerCycle;
        this.numTotalCycles = numTotalCycles;
        this.old = (IronEngineFuel.Fuel)IronEngineFuel.fuels.get(fluid.getName());
    }

    @Override
    public void apply() {
        IronEngineFuel.fuels.remove(this.fluid.getName());
        IronEngineFuel.addFuel((Fluid)this.fluid, (float)this.powerPerCycle, (int)this.numTotalCycles);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        IronEngineFuel.fuels.put(this.fluid.getName(), this.old);
    }

    @Override
    public String describe() {
        return "Altering fuel " + this.fluid.getLocalizedName();
    }

    @Override
    public String describeUndo() {
        return "Restoring fuel " + this.fluid.getLocalizedName();
    }
}

