/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.actions;

import buildcraft.api.fuels.IronEngineCoolant;
import net.minecraftforge.fluids.Fluid;
import stanhebben.minetweaker.api.IUndoableAction;

public class AddLiquidCoolantAction
implements IUndoableAction {
    private final Fluid fluid;
    private final float coolingPerMB;

    public AddLiquidCoolantAction(Fluid fluid, float coolingPerMB) {
        this.fluid = fluid;
        this.coolingPerMB = coolingPerMB;
    }

    @Override
    public void apply() {
        IronEngineCoolant.addCoolant((Fluid)this.fluid, (float)this.coolingPerMB);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        IronEngineCoolant.liquidCoolants.remove(this.fluid.getName());
    }

    @Override
    public String describe() {
        return "Adding coolant liquid " + this.fluid.getName();
    }

    @Override
    public String describeUndo() {
        return "Removing coolant liquid " + this.fluid.getName();
    }
}

