/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.actions;

import buildcraft.api.fuels.IronEngineFuel;
import net.minecraftforge.fluids.Fluid;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerLiquid;

public class AddFuelAction
implements IUndoableAction {
    private final TweakerLiquid fluid;
    private final float powerPerCycle;
    private final int numTotalCycles;

    public AddFuelAction(TweakerLiquid fluid, float powerPerCycle, int numTotalCycles) {
        this.fluid = fluid;
        this.powerPerCycle = powerPerCycle;
        this.numTotalCycles = numTotalCycles;
    }

    @Override
    public void apply() {
        IronEngineFuel.addFuel((Fluid)this.fluid.get(), (float)this.powerPerCycle, (int)this.numTotalCycles);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        IronEngineFuel.fuels.remove(this.fluid.getName());
    }

    @Override
    public String describe() {
        return "Adding a fuel for " + this.fluid.getDisplayName();
    }

    @Override
    public String describeUndo() {
        return "Removing a fuel for " + this.fluid.getDisplayName();
    }
}

