/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.functions;

import java.util.ArrayList;
import net.minecraftforge.oredict.ShapedOreRecipe;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerException;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerArray;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerItemStack;
import stanhebben.minetweaker.api.value.TweakerItemStackPattern;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.base.actions.AddRecipeAction;
import stanhebben.minetweaker.base.functions.recipes.ShapedAdvancedRecipe;
import stanhebben.minetweaker.base.functions.recipes.ShapedFunctionRecipes;
import stanhebben.minetweaker.base.functions.recipes.ShapedOreFunctionRecipe;

public class AddShapedFunction
extends TweakerFunction {
    public static final AddShapedFunction INSTANCE = new AddShapedFunction();

    private AddShapedFunction() {
    }

    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) throws TweakerExecuteException, TweakerException {
        if (arguments.length < 2) {
            throw new TweakerExecuteException("Missing arguments for addShaped");
        }
        TweakerItemStack target = AddShapedFunction.notNull(arguments[0], "cannot use null as addShaped recipe output").toItemStack("addShaped recipe output must be an item stack");
        TweakerArray recipe = AddShapedFunction.notNull(arguments[1], "cannot use null as addShaped recipe").toArray("addShaped recipe must be a twodimensional item array");
        int height = recipe.size();
        int width = 0;
        boolean hasOreEntries = false;
        boolean hasAdvancedEntries = false;
        for (int i = 0; i < height; ++i) {
            TweakerArray recipeRow = AddShapedFunction.notNull(recipe.get(i), "addShaped recipe row must not be null").toArray("addShaped recipe row must be an item array");
            width = Math.max(width, recipeRow.size());
            for (int j = 0; j < recipeRow.size(); ++j) {
                if (recipeRow.get(j) == null) continue;
                Object item = recipeRow.get(j).asRecipeItem();
                if (item != null) {
                    if (item.getClass() != String.class) continue;
                    hasOreEntries = true;
                    continue;
                }
                if (recipeRow.get(j).asItemStackPattern() != null) {
                    hasAdvancedEntries = true;
                    continue;
                }
                throw new TweakerExecuteException("each item in a shaped recipe must be a valid item stack pattern, or null");
            }
        }
        if (hasAdvancedEntries) {
            TweakerItemStackPattern[] stacks = new TweakerItemStackPattern[width * height];
            for (int i = 0; i < height; ++i) {
                TweakerArray row = recipe.get(i).asArray();
                for (int j = 0; j < row.size(); ++j) {
                    int ix = i * width + j;
                    if (row.get(j) == null) continue;
                    stacks[ix] = row.get(j).asItemStackPattern();
                }
            }
            if (arguments.length >= 3) {
                Tweaker.apply(new AddRecipeAction(new ShapedAdvancedRecipe(target, stacks, width, arguments[2])));
            } else {
                Tweaker.apply(new AddRecipeAction(new ShapedAdvancedRecipe(target, stacks, width, null)));
            }
        } else if (hasOreEntries) {
            int counter = 0;
            String[] parts = new String[height];
            ArrayList<Object> rarguments = new ArrayList<Object>();
            for (int i = 0; i < height; ++i) {
                int j;
                StringBuilder pattern = new StringBuilder();
                TweakerArray row = recipe.get(i).asArray();
                for (j = 0; j < row.size(); ++j) {
                    if (row.get(j) != null) {
                        pattern.append((char)(65 + counter));
                        rarguments.add(Character.valueOf((char)(65 + counter)));
                        ++counter;
                        rarguments.add(row.get(j).toRecipeItem("error"));
                        continue;
                    }
                    pattern.append(' ');
                }
                for (j = row.size(); j < width; ++j) {
                    pattern.append(' ');
                }
                parts[i] = pattern.toString();
            }
            rarguments.add(0, parts);
            if (arguments.length >= 3) {
                Tweaker.apply(new AddRecipeAction((aah)new ShapedOreFunctionRecipe(target.get(), rarguments.toArray(), arguments[2])));
            } else {
                Tweaker.apply(new AddRecipeAction((aah)new ShapedOreRecipe(target.get(), rarguments.toArray())));
            }
        } else {
            ye[] stacks = new ye[width * height];
            for (int i = 0; i < height; ++i) {
                TweakerArray row = recipe.get(i).asArray();
                for (int j = 0; j < row.size(); ++j) {
                    int ix = i * width + j;
                    if (row.get(j) == null) continue;
                    stacks[ix] = (ye)row.get(j).toRecipeItem("error");
                }
            }
            if (arguments.length >= 3) {
                Tweaker.apply(new AddRecipeAction((aah)new ShapedFunctionRecipes(width, height, stacks, target.get(), arguments[2])));
            } else {
                Tweaker.apply(new AddRecipeAction((aah)new aai(width, height, stacks, target.get())));
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "MineTweaker:recipes.addShaped";
    }
}

