/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import net.minecraftforge.oredict.OreDictionary;
import stanhebben.minetweaker.api.IUndoableAction;

public final class RemoveOreItemAction
implements IUndoableAction {
    private final String ore;
    private final int index;
    private final ye value;

    public RemoveOreItemAction(String ore, int index) {
        this.ore = ore;
        this.index = index;
        this.value = (ye)OreDictionary.getOres((String)ore).get(index);
    }

    @Override
    public void apply() {
        OreDictionary.getOres((String)this.ore).remove(this.index);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        OreDictionary.getOres((String)this.ore).add(this.index, this.value);
    }

    @Override
    public String describe() {
        return "Removing " + this.value.s() + " from the " + this.ore + " ore dictionary entry.";
    }

    @Override
    public String describeUndo() {
        return "Restoring " + this.value.s() + " to the " + this.ore + " ore dictionary entry.";
    }
}

