/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import net.minecraftforge.fluids.Fluid;
import stanhebben.minetweaker.api.IUndoableAction;

public final class LiquidSetGaseousAction
implements IUndoableAction {
    private final Fluid fluid;
    private final boolean newValue;
    private final boolean oldValue;

    public LiquidSetGaseousAction(Fluid fluid, boolean newValue) {
        this.fluid = fluid;
        this.newValue = newValue;
        this.oldValue = fluid.isGaseous();
    }

    @Override
    public void apply() {
        this.fluid.setGaseous(this.newValue);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        this.fluid.setGaseous(this.oldValue);
    }

    @Override
    public String describe() {
        return "Setting " + this.fluid.getLocalizedName() + " gaseous value to " + this.newValue;
    }

    @Override
    public String describeUndo() {
        return "Restoring " + this.fluid.getLocalizedName() + " gaseous value to " + this.oldValue;
    }
}

