/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.MineTweakerUtil;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;

public final class AddLiquidContainerAction
implements IUndoableAction {
    private final Fluid fluid;
    private final int amount;
    private final TweakerItem emptyContainer;
    private final TweakerItem fullContainer;
    private final boolean isNewEmpty;

    public AddLiquidContainerAction(Fluid fluid, int amount, TweakerItem emptyContainer, TweakerItem fullContainer) {
        this.fluid = fluid;
        this.amount = amount;
        this.emptyContainer = emptyContainer;
        this.fullContainer = fullContainer;
        this.isNewEmpty = FluidContainerRegistry.isEmptyContainer((ye)emptyContainer.make(1));
    }

    @Override
    public void apply() {
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(this.fluid, this.amount), (ye)this.fullContainer.make(1), (ye)this.emptyContainer.make(1));
    }

    @Override
    public boolean canUndo() {
        return MineTweakerUtil.canRemoveContainer();
    }

    @Override
    public void undo() {
        if (this.isNewEmpty) {
            MineTweakerUtil.removeEmptyContainer(this.emptyContainer);
        }
        MineTweakerUtil.removeContainer(this.fullContainer);
    }

    @Override
    public String describe() {
        return "Adding a fluid container: " + this.emptyContainer.getDisplayName() + " + " + this.fluid.getLocalizedName() + " = " + this.fullContainer.getDisplayName();
    }

    @Override
    public String describeUndo() {
        return "Removing fluid container " + this.fullContainer.getDisplayName();
    }
}

