/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import java.util.Iterator;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerArray;
import stanhebben.minetweaker.api.value.TweakerArrayBytes;
import stanhebben.minetweaker.api.value.TweakerArrayInts;
import stanhebben.minetweaker.api.value.TweakerArrayNBT;
import stanhebben.minetweaker.api.value.TweakerBool;
import stanhebben.minetweaker.api.value.TweakerByte;
import stanhebben.minetweaker.api.value.TweakerDouble;
import stanhebben.minetweaker.api.value.TweakerFloat;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerItemPattern;
import stanhebben.minetweaker.api.value.TweakerItemStack;
import stanhebben.minetweaker.api.value.TweakerItemStackPattern;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;
import stanhebben.minetweaker.api.value.TweakerLong;
import stanhebben.minetweaker.api.value.TweakerNBTCompound;
import stanhebben.minetweaker.api.value.TweakerNull;
import stanhebben.minetweaker.api.value.TweakerShort;
import stanhebben.minetweaker.api.value.TweakerString;

public abstract class TweakerValue {
    public static final double DELTA = 1.0E-5;
    private static final byte ID_BYTE = 1;
    private static final byte ID_SHORT = 2;
    private static final byte ID_INT = 3;
    private static final byte ID_LONG = 4;
    private static final byte ID_FLOAT = 5;
    private static final byte ID_DOUBLE = 6;
    private static final byte ID_BYTEARRAY = 7;
    private static final byte ID_STRING = 8;
    private static final byte ID_LIST = 9;
    private static final byte ID_COMPOUND = 10;
    private static final byte ID_INTARRAY = 11;

    public static TweakerValue notNull(TweakerValue value, String error) {
        if (value == null || value == TweakerNull.INSTANCE) {
            throw new TweakerExecuteException(error);
        }
        return value;
    }

    public static boolean isNull(TweakerValue value) {
        return value == null || value == TweakerNull.INSTANCE;
    }

    public static TweakerValue fromNBT(cl tag) {
        switch (tag.a()) {
            case 1: {
                return new TweakerByte(((bx)tag).a);
            }
            case 2: {
                return new TweakerShort(((cj)tag).a);
            }
            case 3: {
                return new TweakerInt(((cf)tag).a);
            }
            case 4: {
                return new TweakerLong(((ch)tag).a);
            }
            case 5: {
                return new TweakerFloat(((cd)tag).a);
            }
            case 6: {
                return new TweakerDouble(((cb)tag).a);
            }
            case 7: {
                return new TweakerArrayBytes(((bw)tag).a);
            }
            case 11: {
                return new TweakerArrayInts(((ce)tag).a);
            }
            case 8: {
                return new TweakerString(((ck)tag).a);
            }
            case 9: {
                return new TweakerArrayNBT((cg)tag);
            }
            case 10: {
                return new TweakerNBTCompound((by)tag);
            }
        }
        throw new TweakerExecuteException("Unsupported tag type: " + tag.a());
    }

    public by toTag(String name) {
        throw new TweakerExecuteException("Cannot convert " + this.toString() + " to an NBT element");
    }

    public TweakerValue[] getTupleValues() {
        return new TweakerValue[]{this};
    }

    public TweakerBool asBool() {
        return null;
    }

    public TweakerBool toBool(String error) {
        TweakerBool result = this.asBool();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerByte asByte() {
        return null;
    }

    public TweakerByte toByte(String error) {
        TweakerByte result = this.asByte();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerShort asShort() {
        return null;
    }

    public TweakerShort toShort(String error) {
        TweakerShort result = this.asShort();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerInt asInt() {
        return null;
    }

    public TweakerInt toInt(String error) {
        TweakerInt result = this.asInt();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerLong asLong() {
        return null;
    }

    public TweakerLong toLong(String error) {
        TweakerLong result = this.asLong();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerString asString() {
        return null;
    }

    public TweakerFloat asFloat() {
        return null;
    }

    public TweakerFloat toFloat(String error) {
        TweakerFloat result = this.asFloat();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerDouble asDouble() {
        return null;
    }

    public TweakerDouble toDouble(String error) {
        TweakerDouble result = this.asDouble();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerItem asItem() {
        return null;
    }

    public TweakerItem toItem(String error) {
        TweakerItem result = this.asItem();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerItemStack asItemStack() {
        return null;
    }

    public TweakerItemStack toItemStack(String error) {
        TweakerItemStack result = this.asItemStack();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerItemPattern asItemPattern() {
        return null;
    }

    public TweakerItemPattern toItemPattern(String error) {
        TweakerItemPattern result = this.asItemPattern();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerItemStackPattern asItemStackPattern() {
        return null;
    }

    public TweakerItemStackPattern toItemStackPattern(String error) {
        TweakerItemStackPattern result = this.asItemStackPattern();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerLiquid asFluid() {
        return null;
    }

    public TweakerLiquid toFluid(String error) {
        TweakerLiquid result = this.asFluid();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerLiquidStack asFluidStack() {
        return null;
    }

    public TweakerLiquidStack toFluidStack(String error) {
        TweakerLiquidStack result = this.asFluidStack();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public TweakerArray asArray() {
        return null;
    }

    public TweakerArray toArray(String error) {
        TweakerArray result = this.asArray();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public Object asRecipeItem() {
        return null;
    }

    public Object toRecipeItem(String error) {
        Object result = this.asRecipeItem();
        if (result == null) {
            throw new TweakerExecuteException(error);
        }
        return result;
    }

    public boolean toBasicBool() {
        TweakerBool result = this.asBool();
        if (result == null) {
            throw new TweakerExecuteException(this.toString() + " cannot be converted to a bool");
        }
        return result.get();
    }

    public int toBasicInt() {
        TweakerInt result = this.asInt();
        if (result == null) {
            throw new TweakerExecuteException(this.toString() + " cannot be converted to an int");
        }
        return result.get();
    }

    public long toBasicLong() {
        TweakerLong result = this.asLong();
        if (result == null) {
            throw new TweakerExecuteException(this.toString() + " cannot be converted to a long");
        }
        return result.get();
    }

    public String toBasicString() {
        TweakerString result = this.asString();
        if (result == null) {
            throw new TweakerExecuteException(this.toString() + " cannot be converted to a string");
        }
        return result.get();
    }

    public TweakerArrayBytes asByteArray() {
        return null;
    }

    public TweakerArrayInts asIntArray() {
        return null;
    }

    public TweakerValue addAssign(TweakerValue other) {
        return this.add(other);
    }

    public TweakerValue subAssign(TweakerValue other) {
        return this.sub(other);
    }

    public TweakerValue mulAssign(TweakerValue other) {
        return this.mul(other);
    }

    public TweakerValue divAssign(TweakerValue other) {
        return this.div(other);
    }

    public TweakerValue modAssign(TweakerValue other) {
        return this.mod(other);
    }

    public TweakerValue orAssign(TweakerValue other) {
        return this.or(other);
    }

    public TweakerValue andAssign(TweakerValue other) {
        return this.and(other);
    }

    public TweakerValue xorAssign(TweakerValue other) {
        return this.xor(other);
    }

    public TweakerValue add(TweakerValue other) {
        throw new TweakerExecuteException("Cannot add " + this.toString() + " and " + (other == null ? "null" : other.toString()));
    }

    public TweakerValue sub(TweakerValue other) {
        throw new TweakerExecuteException("Cannot subtract " + (other == null ? "null" : other.toString()) + " from " + this.toString());
    }

    public TweakerValue mul(TweakerValue other) {
        throw new TweakerExecuteException("Cannot multiply " + this.toString() + " with " + (other == null ? "null" : other.toString()));
    }

    public TweakerValue div(TweakerValue other) {
        throw new TweakerExecuteException("Cannot divide " + this.toString() + " by " + (other == null ? "null" : other.toString()));
    }

    public TweakerValue mod(TweakerValue other) {
        throw new TweakerExecuteException("Cannot mod " + this.toString() + " by " + (other == null ? "null" : other.toString()));
    }

    public TweakerValue neg() {
        throw new TweakerExecuteException("Cannot negate " + this.toString());
    }

    public TweakerValue not() {
        throw new TweakerExecuteException("Cannot invert " + this.toString());
    }

    public TweakerValue or(TweakerValue other) {
        throw new TweakerExecuteException("Cannot or " + this.toString() + " with " + (other == null ? "null" : other.toString()));
    }

    public TweakerValue and(TweakerValue other) {
        throw new TweakerExecuteException("Cannot and " + this.toString() + " with " + (other == null ? "null" : other.toString()));
    }

    public TweakerValue xor(TweakerValue other) {
        throw new TweakerExecuteException("Cannot xor " + this.toString() + " with " + (other == null ? "null" : other.toString()));
    }

    public boolean equals(TweakerValue other) {
        return this == other;
    }

    public int compare(TweakerValue other) {
        throw new TweakerExecuteException(this.toString() + " does not support comparison");
    }

    public TweakerValue index(TweakerValue index) {
        return this.index(TweakerValue.notNull(index, "index must not be null").toBasicString());
    }

    public TweakerValue index(int index) {
        throw new TweakerExecuteException(this.toString() + " does not support indexing with integers");
    }

    public TweakerValue index(String index) {
        throw new TweakerExecuteException("No such member in " + this.toString() + ": " + index);
    }

    public void indexSet(TweakerValue index, TweakerValue value) {
        this.indexSet(TweakerValue.notNull(index, "cannot index by null").toBasicString(), value);
    }

    public void indexSet(String index, TweakerValue value) {
        throw new TweakerExecuteException(this.toString() + " does not support assignments indexed with strings");
    }

    public boolean contains(TweakerValue value) {
        throw new TweakerExecuteException("cannot use the in operand on " + this.toString());
    }

    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        throw new TweakerExecuteException(this.toString() + " cannot be called");
    }

    public cl toTagValue(String name) {
        return null;
    }

    public Iterator<TweakerValue> iterator() {
        throw new TweakerExecuteException(this.toString() + " is not iterable");
    }

    public TweakerValue addToInt(int value) {
        throw new TweakerExecuteException("Cannot add an int value to " + this.toString());
    }

    public TweakerValue addToLong(long value) {
        throw new TweakerExecuteException("Cannot add a long value to " + this.toString());
    }

    public TweakerValue addToFloat(float value) {
        throw new TweakerExecuteException("Cannot add a float value to " + this.toString());
    }

    public TweakerValue addToDouble(double value) {
        throw new TweakerExecuteException("Cannot add a double value to " + this.toString());
    }

    public TweakerValue subToInt(int value) {
        throw new TweakerExecuteException("Cannot add an int value to " + this.toString());
    }

    public TweakerValue subToLong(long value) {
        throw new TweakerExecuteException("Cannot add a long value to " + this.toString());
    }

    public TweakerValue subToFloat(float value) {
        throw new TweakerExecuteException("Cannot add a float value to " + this.toString());
    }

    public TweakerValue subToDouble(double value) {
        throw new TweakerExecuteException("Cannot add a double value to " + this.toString());
    }

    public TweakerValue mulToInt(int value) {
        throw new TweakerExecuteException("Cannot add an int value to " + this.toString());
    }

    public TweakerValue mulToLong(long value) {
        throw new TweakerExecuteException("Cannot add a long value to " + this.toString());
    }

    public TweakerValue mulToFloat(float value) {
        throw new TweakerExecuteException("Cannot add a float value to " + this.toString());
    }

    public TweakerValue mulToDouble(double value) {
        throw new TweakerExecuteException("Cannot add a double value to " + this.toString());
    }

    public TweakerValue divToInt(int value) {
        throw new TweakerExecuteException("Cannot add an int value to " + this.toString());
    }

    public TweakerValue divToLong(long value) {
        throw new TweakerExecuteException("Cannot add a long value to " + this.toString());
    }

    public TweakerValue divToFloat(float value) {
        throw new TweakerExecuteException("Cannot add a float value to " + this.toString());
    }

    public TweakerValue divToDouble(double value) {
        throw new TweakerExecuteException("Cannot add a double value to " + this.toString());
    }

    public TweakerValue modToInt(int value) {
        throw new TweakerExecuteException("Cannot add an int value to " + this.toString());
    }

    public TweakerValue modToLong(long value) {
        throw new TweakerExecuteException("Cannot add a long value to " + this.toString());
    }

    public TweakerValue modToFloat(float value) {
        throw new TweakerExecuteException("Cannot add a float value to " + this.toString());
    }

    public TweakerValue modToDouble(double value) {
        throw new TweakerExecuteException("Cannot add a double value to " + this.toString());
    }

    public TweakerValue orToByte(byte value) {
        throw new TweakerExecuteException("Cannot add a byte value to " + this.toString());
    }

    public TweakerValue orToShort(short value) {
        throw new TweakerExecuteException("Cannot add a short value to " + this.toString());
    }

    public TweakerValue orToInt(int value) {
        throw new TweakerExecuteException("Cannot add an int value to " + this.toString());
    }

    public TweakerValue orToLong(long value) {
        throw new TweakerExecuteException("Cannot add a long value to " + this.toString());
    }

    public TweakerValue andToByte(byte value) {
        throw new TweakerExecuteException("Cannot add a byte value to " + this.toString());
    }

    public TweakerValue andToShort(short value) {
        throw new TweakerExecuteException("Cannot add a short value to " + this.toString());
    }

    public TweakerValue andToInt(int value) {
        throw new TweakerExecuteException("Cannot add an int value to " + this.toString());
    }

    public TweakerValue andToLong(long value) {
        throw new TweakerExecuteException("Cannot add a long value to " + this.toString());
    }

    public TweakerValue xorToByte(byte value) {
        throw new TweakerExecuteException("Cannot add a byte value to " + this.toString());
    }

    public TweakerValue xorToShort(short value) {
        throw new TweakerExecuteException("Cannot add a short value to " + this.toString());
    }

    public TweakerValue xorToInt(int value) {
        throw new TweakerExecuteException("Cannot add an int value to " + this.toString());
    }

    public TweakerValue xorToLong(long value) {
        throw new TweakerExecuteException("Cannot add a long value to " + this.toString());
    }

    public boolean equalsInt(int value) {
        throw new TweakerExecuteException("Cannot compare " + this.toString() + " with long value");
    }

    public boolean equalsLong(long value) {
        throw new TweakerExecuteException("Cannot compare " + this.toString() + " with long value");
    }

    public boolean equalsFloat(float value) {
        throw new TweakerExecuteException("Cannot compare " + this.toString() + " with float value");
    }

    public boolean equalsDouble(double value) {
        throw new TweakerExecuteException("Cannot compare " + this.toString() + " with double value");
    }

    public int compareInt(int value) {
        throw new TweakerExecuteException("Cannot compare " + this.toString() + " with int value");
    }

    public int compareLong(long value) {
        throw new TweakerExecuteException("Cannot compare " + this.toString() + " with long value");
    }

    public int compareFloat(float value) {
        throw new TweakerExecuteException("Cannot compare " + this.toString() + " with float value");
    }

    public int compareDouble(double value) {
        throw new TweakerExecuteException("Cannot compare " + this.toString() + " with double value");
    }

    public abstract String toString();
}

