/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.util.Arrays2;

public class MineTweakerUtil {
    private static final Field oreRecipeWidth = MineTweakerUtil.getPrivateField(ShapedOreRecipe.class, "width");
    private static final Field anvilFile;
    private static final Map<yc, List> toolClasses;
    private static final Map<List, Integer> toolHarvestLevels;
    private static final Set<List> toolHarvestEffective;
    private static final Map<List, FluidContainerRegistry.FluidContainerData> containerFluidMap;
    private static final Map<List, FluidContainerRegistry.FluidContainerData> filledContainerMap;
    private static final Set<List> emptyContainers;

    private MineTweakerUtil() {
    }

    public static Field getPrivateField(Class cls, String ... fieldName) {
        for (String field : fieldName) {
            try {
                Field result = cls.getDeclaredField(field);
                result.setAccessible(true);
                return result;
            }
            catch (NoSuchFieldException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T getPrivateStaticObject(Class cls, String ... fieldName) {
        for (String field : fieldName) {
            try {
                Field result = cls.getDeclaredField(field);
                result.setAccessible(true);
                return (T)result.get(null);
            }
            catch (NoSuchFieldException ex) {
            }
            catch (SecurityException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getOreDictionary(List item) {
        return OreDictionary.getOreName((int)OreDictionary.getOreID((ye)((ye)item.get(0))));
    }

    public static boolean hasShapedOreRecipeWidth() {
        return oreRecipeWidth != null;
    }

    public static int getShapedOreRecipeWidth(ShapedOreRecipe recipe) {
        if (oreRecipeWidth == null) {
            return 1;
        }
        try {
            return oreRecipeWidth.getInt(recipe);
        }
        catch (IllegalArgumentException e) {
            Tweaker.log(Level.WARNING, "Could not get shapedRecipeOreWidth field", e);
        }
        catch (IllegalAccessException e) {
            Tweaker.log(Level.WARNING, "Could not get shapedRecipeOreWidth field", e);
        }
        return 1;
    }

    public static String getItemString(ye stack) {
        if (stack == null) {
            return "null";
        }
        return stack.k() == Short.MAX_VALUE ? Integer.toString(stack.d) : stack.d + ":" + stack.k();
    }

    public static String getItemStackString(ye stack) {
        String base = MineTweakerUtil.getItemString(stack);
        if (stack.b != 1) {
            base = base + " * " + stack.b;
        }
        return base;
    }

    public static String getRecipeString(aah recipe) {
        if (recipe instanceof aai) {
            aai shapedRecipe = (aai)recipe;
            StringBuilder result = new StringBuilder();
            result.append("Shaped ").append(shapedRecipe.b).append('x').append(shapedRecipe.c).append(": ");
            result.append(MineTweakerUtil.getItemStackString(recipe.b()));
            result.append(" = [[");
            for (int i = 0; i < shapedRecipe.c; ++i) {
                if (i > 0) {
                    result.append("], [");
                }
                for (int j = 0; j < shapedRecipe.b; ++j) {
                    if (j > 0) {
                        result.append(", ");
                    }
                    result.append(MineTweakerUtil.getItemString(shapedRecipe.d[i * shapedRecipe.b + j]));
                }
            }
            result.append("]]");
            return result.toString();
        }
        if (recipe instanceof aaj) {
            aaj shapelessRecipe = (aaj)recipe;
            StringBuilder result = new StringBuilder();
            result.append("Shapeless: ");
            result.append(MineTweakerUtil.getItemStackString(recipe.b()));
            result.append(" = [");
            for (int i = 0; i < recipe.a(); ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(MineTweakerUtil.getItemString((ye)shapelessRecipe.b.get(i)));
            }
            result.append("]");
            return result.toString();
        }
        if (recipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe shapedRecipe = (ShapedOreRecipe)recipe;
            int recipeWidth = MineTweakerUtil.getShapedOreRecipeWidth(shapedRecipe);
            int recipeHeight = shapedRecipe.a() / recipeWidth;
            StringBuilder result = new StringBuilder();
            result.append("Shaped Ore ").append(recipeWidth).append("x").append(recipeHeight).append(": ");
            result.append(MineTweakerUtil.getItemStackString(recipe.b()));
            result.append(" = [[");
            for (int i = 0; i < recipeHeight; ++i) {
                if (i > 0) {
                    result.append("], [");
                }
                for (int j = 0; j < recipeWidth; ++j) {
                    Object input;
                    if (j > 0) {
                        result.append(", ");
                    }
                    if ((input = shapedRecipe.getInput()[i * recipeWidth + j]) == null) {
                        result.append("null");
                        continue;
                    }
                    if (input instanceof ye) {
                        result.append(MineTweakerUtil.getItemString((ye)input));
                        continue;
                    }
                    if (input instanceof List) {
                        result.append("oreDict.").append(MineTweakerUtil.getOreDictionary((List)input));
                        continue;
                    }
                    result.append(input.toString());
                }
            }
            return result.toString();
        }
        if (recipe instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe shapelessRecipe = (ShapelessOreRecipe)recipe;
            StringBuilder result = new StringBuilder();
            result.append("Shapeless Ore: ");
            result.append(MineTweakerUtil.getItemStackString(shapelessRecipe.b()));
            result.append(" = [");
            for (int i = 0; i < shapelessRecipe.a(); ++i) {
                Object input;
                if (i > 0) {
                    result.append(", ");
                }
                if ((input = shapelessRecipe.getInput().get(i)) instanceof ye) {
                    result.append(MineTweakerUtil.getItemString((ye)input));
                    continue;
                }
                if (input instanceof List) {
                    result.append("oreDict.").append(MineTweakerUtil.getOreDictionary((List)input));
                    continue;
                }
                result.append(input.toString());
            }
            return result.toString();
        }
        return "(" + recipe.getClass() + ") " + MineTweakerUtil.getItemStackString(recipe.b());
    }

    public static File getAnvilFile(MinecraftServer server) {
        if (anvilFile == null) {
            return null;
        }
        try {
            return (File)anvilFile.get(server);
        }
        catch (IllegalArgumentException e) {
            Tweaker.log(Level.WARNING, "Could not get anvilFile field", e);
        }
        catch (IllegalAccessException e) {
            Tweaker.log(Level.WARNING, "Could not get anvilFile field", e);
        }
        return null;
    }

    public static File getWorldDirectory(MinecraftServer server) {
        if (server.V()) {
            return server.d("world");
        }
        File worldsDir = MineTweakerUtil.getAnvilFile(server);
        if (worldsDir == null) {
            return null;
        }
        return new File(worldsDir, server.L());
    }

    public static void getSubBlocks(int id, List<ye> output) {
        block14: {
            aqz block = aqz.s[id];
            if (block == null) {
                return;
            }
            if (MinecraftServer.F() != null && MinecraftServer.F().V()) {
                Class<?> cls = block.getClass();
                Method method = null;
                try {
                    method = cls.getMethod("func_71879_a", Integer.TYPE, ww.class, List.class);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                if (method == null) {
                    try {
                        method = cls.getMethod("getSubBlocks", Integer.TYPE, ww.class, List.class);
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                }
                if (method == null) {
                    HashSet<String> found = new HashSet<String>();
                    int i = 0;
                    while (true) {
                        ye value = new ye(id, 1, i);
                        try {
                            String name = aqz.s[id].a();
                            if (name == null || found.contains(name)) break block14;
                            found.add(name);
                            output.add(value);
                        }
                        catch (Throwable ex) {
                            break block14;
                        }
                        ++i;
                    }
                }
                try {
                    method.invoke((Object)block, id, null, output);
                }
                catch (Throwable ex) {}
            } else {
                block.a(id, null, output);
            }
        }
    }

    public static void getSubItems(int id, List<ye> output) {
        yc item = yc.g[id];
        if (item == null) {
            return;
        }
        if (MinecraftServer.F() != null && MinecraftServer.F().V()) {
            Class<?> cls = item.getClass();
            Method method = null;
            try {
                method = cls.getMethod("func_77633_a", Integer.TYPE, ww.class, List.class);
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (method == null) {
                try {
                    method = cls.getMethod("getSubItems", Integer.TYPE, ww.class, List.class);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            if (method == null) {
                HashSet<String> found = new HashSet<String>();
                int i = 0;
                while (true) {
                    block15: {
                        block14: {
                            ye value = new ye(id, 1, i);
                            try {
                                String name = yc.g[id].a();
                                if (name == null || found.contains(name)) break block14;
                                found.add(name);
                                output.add(value);
                                break block15;
                            }
                            catch (Throwable ex) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    ++i;
                }
            }
            try {
                method.invoke((Object)item, id, null, output);
            }
            catch (Throwable ex) {}
        } else {
            item.a(id, null, output);
        }
    }

    public static String formatItemName(String itemName) {
        String[] components = Arrays2.split(itemName, '.');
        StringBuilder result = new StringBuilder();
        if (!itemName.startsWith("item.") && !itemName.startsWith("tile.")) {
            result.append("items.");
        }
        boolean first = true;
        for (String s : components) {
            if (first) {
                first = false;
            } else {
                result.append('.');
            }
            if (MineTweakerUtil.isIdentifier(s)) {
                result.append(s);
                continue;
            }
            result.append('\"').append(s).append('\"');
        }
        return result.toString();
    }

    private static boolean isIdentifier(String id) {
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (char c : id.toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean canRemoveContainer() {
        return emptyContainers != null && containerFluidMap != null && filledContainerMap != null;
    }

    public static boolean hasEmptyContainer(TweakerItem item) {
        return emptyContainers.contains(Arrays.asList(item.getItemId(), item.getItemSubId()));
    }

    public static boolean removeEmptyContainer(TweakerItem item) {
        return emptyContainers.remove(Arrays.asList(item.getItemId(), item.getItemSubId()));
    }

    public static boolean removeContainer(TweakerItem filled) {
        List<Integer> filledId = Arrays.asList(filled.getItemId(), filled.getItemSubId());
        if (filledContainerMap.containsKey(filledId)) {
            FluidContainerRegistry.FluidContainerData data = filledContainerMap.get(filledId);
            filledContainerMap.remove(filledId);
            containerFluidMap.remove(Arrays.asList(data.emptyContainer.d, data.emptyContainer.k(), data.fluid));
            return true;
        }
        return false;
    }

    public static FluidContainerRegistry.FluidContainerData getContainerData(TweakerItem filled) {
        return filledContainerMap.get(Arrays.asList(filled.getItemId(), filled.getItemSubId()));
    }

    public static Integer getBlockHarvestLevel(aqz block, int meta, String tool) {
        if (toolHarvestLevels == null) {
            return -1;
        }
        return toolHarvestLevels.get(Arrays.asList(block, meta, tool));
    }

    public static boolean isHarvestEffective(aqz block, int meta, String tool) {
        if (toolHarvestEffective == null) {
            return false;
        }
        return toolHarvestEffective.contains(Arrays.asList(block, meta, tool));
    }

    public static void removeBlockTool(aqz block, int meta, String tool) {
        if (toolHarvestLevels == null) {
            return;
        }
        if (toolHarvestEffective == null) {
            return;
        }
        toolHarvestLevels.remove(Arrays.asList(block, meta, tool));
        toolHarvestEffective.remove(Arrays.asList(block, meta, tool));
    }

    public static List getToolClass(yc item) {
        if (toolClasses == null) {
            return null;
        }
        return toolClasses.get(item);
    }

    public static void setToolClass(yc item, List value) {
        if (toolClasses == null) {
            return;
        }
        toolClasses.put(item, value);
    }

    static {
        if (oreRecipeWidth == null) {
            Tweaker.log(Level.SEVERE, "Could not get ShapedOreRecipe width field. Cannot use ore recipe patterns.");
        }
        if ((anvilFile = MineTweakerUtil.getPrivateField(MinecraftServer.class, "field_71308_o", "anvilFile")) == null) {
            Tweaker.log(Level.SEVERE, "Could not get MinecraftServer anvilFile field. Cannot use server scripts.");
        }
        toolClasses = (Map)MineTweakerUtil.getPrivateStaticObject(ForgeHooks.class, "toolClasses");
        toolHarvestLevels = (Map)MineTweakerUtil.getPrivateStaticObject(ForgeHooks.class, "toolHarvestLevels");
        toolHarvestEffective = (Set)MineTweakerUtil.getPrivateStaticObject(ForgeHooks.class, "toolEffectiveness");
        containerFluidMap = (Map)MineTweakerUtil.getPrivateStaticObject(FluidContainerRegistry.class, "containerFluidMap");
        if (containerFluidMap == null) {
            Tweaker.log(Level.SEVERE, "Could not get FluidContainerRegistry containerFluidMap field. Cannot remove fluid containers.");
        }
        if ((filledContainerMap = (Map)MineTweakerUtil.getPrivateStaticObject(FluidContainerRegistry.class, "filledContainerMap")) == null) {
            Tweaker.log(Level.SEVERE, "Could not get FluidContainerRegistry filledContainerMap field. Cannot remove fluid containers.");
        }
        if ((emptyContainers = (Set)MineTweakerUtil.getPrivateStaticObject(FluidContainerRegistry.class, "emptyContainers")) == null) {
            Tweaker.log(Level.SEVERE, "Could not get FluidContainerRegistry emptyContainers field. Cannot remove fluid containers.");
        }
    }
}

