/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.minetweaker.MineTweakerUtil;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerItemSimple;
import stanhebben.minetweaker.api.value.TweakerItemSub;

public class MineTweakerRegistry {
    public static final MineTweakerRegistry INSTANCE = new MineTweakerRegistry();
    private final HashSet<String> itemPrefixes;
    private final HashMap<String, TweakerItem> itemsByName;
    private final ArrayList<TweakerItem> allItems;
    private final HashSet<String> blockPrefixes = new HashSet();
    private final HashMap<String, TweakerItem> blocksByName = new HashMap();
    private final HashSet<String> fluidPrefixes;

    private MineTweakerRegistry() {
        this.itemPrefixes = new HashSet();
        this.itemsByName = new HashMap();
        this.allItems = new ArrayList();
        this.fluidPrefixes = new HashSet();
    }

    public void init() {
        String name;
        TweakerItemSub value;
        TweakerItemSimple allValue;
        try {
            for (yc item : yc.g) {
                if (item == null) continue;
                allValue = new TweakerItemSimple(item.cv);
                if (allValue.getName() != null) {
                    this.collectPrefixes(allValue.getName(), this.itemPrefixes);
                    this.itemsByName.put(allValue.getName(), allValue);
                    this.allItems.add(allValue);
                }
                if (!item.n()) continue;
                try {
                    ArrayList<ye> subItems = new ArrayList<ye>();
                    MineTweakerUtil.getSubItems(item.cv, subItems);
                    for (ye subItem : subItems) {
                        value = new TweakerItemSub(subItem.d, subItem.k());
                        name = value.getName();
                        if (name == null) continue;
                        this.collectPrefixes(value.getName(), this.itemPrefixes);
                        this.itemsByName.put(value.getName(), value);
                        this.allItems.add(value);
                    }
                }
                catch (TweakerExecuteException ex) {
                    Tweaker.log(Level.WARNING, "Exception loading " + item.a() + " subitems: " + ex.getMessage());
                }
                catch (Exception ex) {
                    Tweaker.log(Level.WARNING, "Exception loading " + item.a() + " subitems: " + ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            Tweaker.log(Level.SEVERE, "Exception loading items", ex);
        }
        try {
            for (aqz block : aqz.s) {
                if (block == null || block.cF == 0 || yc.g[block.cF] == null) continue;
                allValue = new TweakerItemSimple(block.cF);
                if (allValue.getName() != null) {
                    this.collectPrefixes(allValue.getName(), this.blockPrefixes);
                    this.blocksByName.put(allValue.getName(), allValue);
                }
                if (!yc.g[block.cF].n()) continue;
                try {
                    ArrayList<ye> subBlocks = new ArrayList<ye>();
                    MineTweakerUtil.getSubBlocks(block.cF, subBlocks);
                    for (ye subBlock : subBlocks) {
                        value = new TweakerItemSub(block.cF, subBlock.k());
                        name = value.getName();
                        if (name == null) continue;
                        this.collectPrefixes(value.getName(), this.blockPrefixes);
                        this.blocksByName.put(value.getName(), value);
                    }
                }
                catch (TweakerExecuteException ex) {
                    Tweaker.log(Level.WARNING, "Exception loading " + allValue.getName() + " subitems: " + ex.getMessage());
                }
                catch (Exception ex) {
                    Tweaker.log(Level.WARNING, "Exception loading " + allValue.getName() + " subitems: " + ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            Tweaker.log(Level.SEVERE, "Exception loading blocks", ex);
        }
        for (String name2 : FluidRegistry.getRegisteredFluidIDs().keySet()) {
            this.collectPrefixes(name2, this.fluidPrefixes);
        }
    }

    public TweakerItem getBlock(String name) {
        return this.blocksByName.get(name);
    }

    public boolean isBlockPrefix(String value) {
        return this.blockPrefixes.contains(value);
    }

    public TweakerItem getItem(String name) {
        return this.itemsByName.get(name);
    }

    public boolean isItemPrefix(String value) {
        return this.itemPrefixes.contains(value);
    }

    public TweakerItem getAny(String name) {
        if (this.blocksByName.containsKey(name)) {
            return this.blocksByName.get(name);
        }
        return this.itemsByName.get(name);
    }

    public boolean isFluidPrefix(String value) {
        return this.fluidPrefixes.contains(value);
    }

    public List<TweakerItem> getAllItems() {
        return this.allItems;
    }

    private void collectPrefixes(String value, HashSet<String> prefixes) {
        String prefix;
        int dot = value.lastIndexOf(46);
        if (dot > 0 && !prefixes.contains(prefix = value.substring(0, dot))) {
            prefixes.add(prefix);
            this.collectPrefixes(prefix, prefixes);
        }
    }
}

