/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.IAEItemStack;
import appeng.api.config.SortDir;
import appeng.common.AppEngConfiguration;
import appeng.util.AEItemStack;
import appeng.util.Platform;
import java.util.Comparator;
import net.minecraft.item.ItemStack;

public class ItemSorters {
    public static Comparator<IAEItemStack> ConfigBased_SortByPriority = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            if (AppEngConfiguration.SortDirection == SortDir.ASC) {
                return ItemSorters.compareInt(((AEItemStack)o1).priority, ((AEItemStack)o2).priority);
            }
            return ItemSorters.compareInt(((AEItemStack)o2).priority, ((AEItemStack)o1).priority);
        }
    };
    public static Comparator<IAEItemStack> ConfigBased_SortByName = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            if (AppEngConfiguration.SortDirection == SortDir.ASC) {
                return Platform.getItemDisplayName(o1).compareTo(Platform.getItemDisplayName(o2));
            }
            return Platform.getItemDisplayName(o2).compareTo(Platform.getItemDisplayName(o1));
        }
    };
    public static Comparator<IAEItemStack> ConfigBased_SortByID = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            if (AppEngConfiguration.SortDirection == SortDir.ASC) {
                int comp = ItemSorters.compareInt(o1.getItemID(), o2.getItemID());
                if (comp == 0) {
                    comp = ItemSorters.compareInt(o1.getItemDamage(), o2.getItemDamage());
                }
                return comp;
            }
            int comp = -ItemSorters.compareInt(o1.getItemID(), o2.getItemID());
            if (comp == 0) {
                comp = -ItemSorters.compareInt(o1.getItemDamage(), o2.getItemDamage());
            }
            return comp;
        }
    };
    public static Comparator<IAEItemStack> ConfigBased_SortBySize = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            if (AppEngConfiguration.SortDirection == SortDir.ASC) {
                return ItemSorters.compareLong(o2.getStackSize(), o1.getStackSize());
            }
            return ItemSorters.compareLong(o1.getStackSize(), o2.getStackSize());
        }
    };
    public static Comparator<IAEItemStack> Accending_SortByID = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            int comp = ItemSorters.compareInt(o1.getItemID(), o2.getItemID());
            if (comp == 0) {
                comp = ItemSorters.compareInt(o1.getItemDamage(), o2.getItemDamage());
            }
            return comp;
        }
    };
    public static Comparator<IAEItemStack> Decending_SortByID = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            int comp = ItemSorters.compareInt(o2.getItemID(), o1.getItemID());
            if (comp == 0) {
                comp = ItemSorters.compareInt(o2.getItemDamage(), o1.getItemDamage());
            }
            return comp;
        }
    };
    public static Comparator<IAEItemStack> Accending_SortBySize = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            return ItemSorters.compareLong(o1.getStackSize(), o2.getStackSize());
        }
    };
    public static Comparator<IAEItemStack> Decending_SortBySize = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            return ItemSorters.compareLong(o2.getStackSize(), o1.getStackSize());
        }
    };
    public static Comparator<ItemStack> Accending_SortByID_Vanilla = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            int comp = ItemSorters.compareInt(o1.field_77993_c, o2.field_77993_c);
            if (comp == 0) {
                comp = ItemSorters.compareInt(o1.func_77960_j(), o2.func_77960_j());
            }
            return comp;
        }
    };
    public static Comparator<ItemStack> Decending_SortByID_Vanilla = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            int comp = ItemSorters.compareInt(o2.field_77993_c, o1.field_77993_c);
            if (comp == 0) {
                comp = ItemSorters.compareInt(o2.func_77960_j(), o1.func_77960_j());
            }
            return comp;
        }
    };
    public static Comparator<ItemStack> Accending_SortBySize_Vanilla = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            return ItemSorters.compareInt(o1.field_77994_a, o2.field_77994_a);
        }
    };
    public static Comparator<ItemStack> Decending_SortBySize_Vanilla = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            return ItemSorters.compareInt(o2.field_77994_a, o1.field_77994_a);
        }
    };

    public static int compareInt(int a, int b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static int compareLong(long a, long b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }
}

