/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.IAEItemStack;
import appeng.api.IAETagCompound;
import appeng.util.Platform;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;

public final class AEItemStack
implements IAEItemStack,
Comparable<AEItemStack> {
    private int def;
    private int itemID;
    private int damageValue;
    private int oreID;
    private IAETagCompound tagCompound;
    private int myHash;
    private boolean isCraftable;
    private long stackSize;
    private long countRequestable;
    public int priority;
    @SideOnly(value=Side.CLIENT)
    private String displayName;
    @SideOnly(value=Side.CLIENT)
    private List tooltip;

    @Override
    public void add(IAEItemStack option) {
        if (this.priority < ((AEItemStack)option).priority) {
            this.priority = ((AEItemStack)option).priority;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    private AEItemStack(AEItemStack is) {
        this.itemID = is.itemID;
        this.damageValue = is.damageValue;
        this.def = is.def;
        this.oreID = is.oreID;
        this.stackSize = is.stackSize;
        this.tagCompound = is.tagCompound;
        this.priority = is.priority;
        this.setCraftable(is.isCraftable());
        this.setCountRequestable(is.getCountRequestable());
        this.myHash = is.myHash;
    }

    protected AEItemStack(ItemStack is) {
        if (is == null) {
            throw new RuntimeException("Invalid Itemstack.");
        }
        this.itemID = is.field_77993_c;
        this.damageValue = Item.field_77731_bo.getDamage(is);
        this.oreID = Platform.getOreID(is);
        this.def = this.damageValue << 16 | this.itemID;
        this.stackSize = is.field_77994_a;
        this.tagCompound = (IAETagCompound)Platform.getSharedTagCompound(is);
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.myHash = this.def ^ (this.tagCompound == null ? 0 : System.identityHashCode(this.tagCompound));
    }

    public static AEItemStack create(Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof IAEItemStack) {
            ((IAEItemStack)a).copy();
        }
        if (a instanceof ItemStack) {
            return new AEItemStack((ItemStack)a);
        }
        return null;
    }

    @Override
    public Item getItem() {
        return Item.field_77698_e[this.itemID];
    }

    @Override
    public boolean equals(Object ia) {
        if (ia instanceof AEItemStack) {
            return ((AEItemStack)ia).getDef() == this.getDef() && this.tagCompound == ((AEItemStack)ia).tagCompound;
        }
        if (ia instanceof ItemStack) {
            ItemStack is = (ItemStack)ia;
            if (is.field_77993_c == this.itemID && is.func_77960_j() == this.damageValue) {
                NBTTagCompound ta = (NBTTagCompound)this.tagCompound;
                NBTTagCompound tb = is.func_77978_p();
                if (ta == tb) {
                    return true;
                }
                if (ta == null && tb == null || ta != null && ta.func_82582_d() && tb == null || tb != null && tb.func_82582_d() && ta == null || ta != null && ta.func_82582_d() && tb != null && tb.func_82582_d()) {
                    return true;
                }
                if (ta == null && tb != null || ta != null && tb == null) {
                    return false;
                }
                if (Platform.isShared(tb)) {
                    return ta == tb;
                }
                return Platform.NBTEqualityTest((NBTBase)ta, (NBTBase)tb);
            }
        }
        return false;
    }

    public ItemStack getSharedItemStack() {
        ItemStack is = new ItemStack(this.itemID, (int)Math.min(Integer.MAX_VALUE, this.stackSize), this.damageValue);
        if (this.tagCompound != null) {
            is.func_77982_d((NBTTagCompound)this.tagCompound);
        }
        return is;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack is = new ItemStack(this.itemID, (int)Math.min(Integer.MAX_VALUE, this.stackSize), this.damageValue);
        if (this.tagCompound != null) {
            is.func_77982_d(this.tagCompound.getNBTTagCompoundCopy());
        }
        return is;
    }

    @Override
    public int getItemID() {
        return this.itemID;
    }

    @Override
    public int getItemDamage() {
        return this.damageValue;
    }

    @Override
    public IAETagCompound getTagCompound() {
        return this.tagCompound;
    }

    @Override
    public boolean isMeaninful() {
        return this.stackSize > 0L || this.getCountRequestable() > 0L || this.isCraftable();
    }

    @Override
    public IAEItemStack copy() {
        return new AEItemStack(this);
    }

    @Override
    public void reset() {
        this.stackSize = 0L;
        this.priority = Integer.MIN_VALUE;
        this.setCountRequestable(0L);
        this.setCraftable(false);
    }

    @Override
    public long getStackSize() {
        return this.stackSize;
    }

    @Override
    public void setStackSize(long ss) {
        this.stackSize = ss;
    }

    @Override
    public void writeToNBT(NBTTagCompound i) {
        NBTBase id = i.func_74781_a("id");
        NBTBase Count = i.func_74781_a("Count");
        NBTBase Priority = i.func_74781_a("Priority");
        NBTBase Cnt = i.func_74781_a("Cnt");
        NBTBase Req = i.func_74781_a("Req");
        NBTBase Craft = i.func_74781_a("Craft");
        NBTBase Damage = i.func_74781_a("Damage");
        if (id != null && id instanceof NBTTagShort) {
            ((NBTTagShort)id).field_74752_a = (short)this.itemID;
        } else {
            i.func_74777_a("id", (short)this.itemID);
        }
        if (Priority != null && Priority instanceof NBTTagInt) {
            ((NBTTagInt)Priority).field_74748_a = this.priority;
        } else {
            i.func_74768_a("Priority", this.priority);
        }
        if (Count != null && Count instanceof NBTTagByte) {
            ((NBTTagByte)Count).field_74756_a = 0;
        } else {
            i.func_74774_a("Count", (byte)0);
        }
        if (Cnt != null && Cnt instanceof NBTTagLong) {
            ((NBTTagLong)Cnt).field_74753_a = this.stackSize;
        } else {
            i.func_74772_a("Cnt", this.stackSize);
        }
        if (Req != null && Req instanceof NBTTagLong) {
            ((NBTTagLong)Req).field_74753_a = this.stackSize;
        } else {
            i.func_74772_a("Req", this.getCountRequestable());
        }
        if (Craft != null && Craft instanceof NBTTagByte) {
            ((NBTTagByte)Craft).field_74756_a = (byte)(this.isCraftable() ? 1 : 0);
        } else {
            i.func_74757_a("Craft", this.isCraftable());
        }
        if (Damage != null && Damage instanceof NBTTagShort) {
            ((NBTTagShort)Damage).field_74752_a = (short)this.damageValue;
        } else {
            i.func_74777_a("Damage", (short)this.damageValue);
        }
        if (this.tagCompound != null) {
            i.func_74782_a("tag", (NBTBase)((NBTTagCompound)this.tagCompound));
        } else {
            i.func_82580_o("tag");
        }
    }

    public static IAEItemStack loadItemStackFromNBT(NBTTagCompound i) {
        ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)i);
        if (itemstack == null) {
            return null;
        }
        AEItemStack aeis = AEItemStack.create(itemstack);
        aeis.priority = i.func_74762_e("Priority");
        aeis.stackSize = i.func_74763_f("Cnt");
        aeis.setCountRequestable(i.func_74763_f("Req"));
        aeis.setCraftable(i.func_74767_n("Craft"));
        return aeis;
    }

    @Override
    public long getCountRequestable() {
        return this.countRequestable;
    }

    @Override
    public void setCountRequestable(long countRequestable) {
        this.countRequestable = countRequestable;
    }

    @Override
    public boolean isCraftable() {
        return this.isCraftable;
    }

    @Override
    public void setCraftable(boolean isCraftable) {
        this.isCraftable = isCraftable;
    }

    @Override
    public int getDef() {
        return this.def;
    }

    @Override
    public boolean hasTagCompound() {
        return this.tagCompound != null;
    }

    @Override
    public void decStackSize(long i) {
        this.stackSize -= i;
    }

    @Override
    public void incStackSize(long i) {
        this.stackSize += i;
    }

    @Override
    public void decCountRequestable(long i) {
        this.countRequestable -= i;
    }

    @Override
    public void incCountRequestable(long i) {
        this.countRequestable += i;
    }

    public int hashCode() {
        return this.myHash;
    }

    @Override
    public int compareTo(AEItemStack b) {
        int diff = this.hashCode() - b.hashCode();
        return diff > 0 ? 1 : (diff < 0 ? -1 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public List getToolTip() {
        if (this.tooltip != null) {
            return this.tooltip;
        }
        this.tooltip = Platform.getTooltip(this.getItemStack());
        return this.tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        this.displayName = Platform.getItemDisplayName(this.getItemStack());
        return this.displayName;
    }

    @Override
    public boolean sameOre(Object is) {
        if (is == null) {
            return false;
        }
        if (this.oreID == -1) {
            return false;
        }
        if (is instanceof AEItemStack) {
            return this.oreID == ((AEItemStack)is).oreID;
        }
        if (is instanceof Integer) {
            return this.oreID == (Integer)is;
        }
        return false;
    }

    public boolean isOre() {
        return this.oreID != -1;
    }

    void putPacketValue(DataOutputStream tag, long num) throws IOException {
        if (num <= 255L) {
            tag.writeByte((byte)(num + -128L));
        } else if (num <= 65535L) {
            tag.writeShort((short)(num + -32768L));
        } else if (num <= 0xFFFFFFFFL) {
            tag.writeInt((int)(num + Integer.MIN_VALUE));
        } else {
            tag.writeLong(num);
        }
    }

    static long getPacketValue(byte type, DataInputStream tag) throws IOException {
        if (type == 0) {
            long l = tag.readByte();
            return l -= -128L;
        }
        if (type == 1) {
            long l = tag.readShort();
            return l -= -32768L;
        }
        if (type == 2) {
            long l = tag.readInt();
            return l -= Integer.MIN_VALUE;
        }
        return tag.readLong();
    }

    byte getType(long num) {
        if (num <= 255L) {
            return 0;
        }
        if (num <= 65535L) {
            return 1;
        }
        if (num <= 0xFFFFFFFFL) {
            return 2;
        }
        return 3;
    }

    @Override
    public void writeToPacket(DataOutputStream i) throws IOException {
        byte mask = (byte)(this.getType(this.priority) | this.getType(this.stackSize) << 2 | this.getType(this.getCountRequestable()) << 4 | (byte)(this.isCraftable ? 1 : 0) << 6 | (this.hasTagCompound() ? 1 : 0) << 7);
        i.writeByte(mask);
        i.writeShort(this.getItemID());
        i.writeShort(this.getItemDamage());
        if (this.hasTagCompound()) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)this.getTagCompound()), (DataOutput)data);
            byte[] tagBytes = bytes.toByteArray();
            int size = tagBytes.length;
            i.writeInt(size);
            i.write(tagBytes);
        }
        this.putPacketValue(i, this.priority);
        this.putPacketValue(i, this.stackSize);
        this.putPacketValue(i, this.getCountRequestable());
    }

    public static IAEItemStack loadItemStackFromPacket(DataInputStream data) throws IOException {
        byte mask = data.readByte();
        byte PriorityType = (byte)(mask & 3);
        byte StackType = (byte)((mask & 0xC) >> 2);
        byte CountReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        boolean hasTagCompound = (mask & 0x80) > 0;
        NBTTagCompound d = new NBTTagCompound();
        d.func_74777_a("id", data.readShort());
        d.func_74777_a("Damage", data.readShort());
        d.func_74774_a("Count", (byte)0);
        if (hasTagCompound) {
            int len = data.readInt();
            byte[] bd = new byte[len];
            data.readFully(bd);
            ByteArrayDataInput di = ByteStreams.newDataInput((byte[])bd);
            d.func_74766_a("tag", CompressedStreamTools.func_74794_a((DataInput)di));
        }
        long priority = AEItemStack.getPacketValue(PriorityType, data);
        long stackSize = AEItemStack.getPacketValue(StackType, data);
        long countRequestable = AEItemStack.getPacketValue(CountReqType, data);
        ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)d);
        if (itemstack == null) {
            return null;
        }
        AEItemStack aeis = AEItemStack.create(itemstack);
        aeis.priority = (int)priority;
        aeis.stackSize = stackSize;
        aeis.setCountRequestable(countRequestable);
        aeis.setCraftable(isCraftable);
        return aeis;
    }
}

